/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.export;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImportedImage;
import org.openstreetmap.josm.plugins.streetside.io.export.StreetsideExportDownloadThread;
import org.openstreetmap.josm.plugins.streetside.io.export.StreetsideExportWriterThread;
import org.openstreetmap.josm.tools.I18n;

public class StreetsideExportManager
extends PleaseWaitRunnable {
    static final Logger logger = Logger.getLogger(StreetsideExportManager.class);
    private final ArrayBlockingQueue<BufferedImage> queue = new ArrayBlockingQueue(10);
    private final ArrayBlockingQueue<StreetsideAbstractImage> queueImages = new ArrayBlockingQueue(10);
    private int amount;
    private Set<StreetsideAbstractImage> images;
    private String path;
    private Thread writer;
    private ThreadPoolExecutor ex;

    public StreetsideExportManager(Set<StreetsideAbstractImage> images, String path) {
        super(I18n.tr((String)"Downloading", (Object[])new Object[0]) + "\u2026", (ProgressMonitor)new PleaseWaitProgressMonitor(I18n.tr((String)"Exporting Streetside Images", (Object[])new Object[0])), true);
        this.images = images == null ? new HashSet() : images;
        this.path = path;
        this.amount = this.images.size();
    }

    public StreetsideExportManager(List<StreetsideImportedImage> images) throws IOException {
        this(null, null);
        for (StreetsideImportedImage image : images) {
            this.queue.add(image.getImage());
            this.queueImages.add(image);
        }
        this.amount = images.size();
    }

    protected void cancel() {
        this.writer.interrupt();
        this.ex.shutdown();
    }

    protected void realRun() throws IOException {
        this.writer = new StreetsideExportWriterThread(this.path, this.queue, this.queueImages, this.amount, this.getProgressMonitor());
        this.writer.start();
        if (this.path == null) {
            try {
                this.writer.join();
            }
            catch (InterruptedException e) {
                logger.error(e);
            }
            return;
        }
        this.ex = new ThreadPoolExecutor(20, 35, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        for (StreetsideAbstractImage image : this.images) {
            if (image instanceof StreetsideImage) {
                try {
                    this.ex.execute(new StreetsideExportDownloadThread((StreetsideImage)image, this.queue, this.queueImages));
                }
                catch (Exception e) {
                    logger.error(e);
                }
            } else if (image instanceof StreetsideImportedImage) {
                try {
                    this.queue.put(((StreetsideImportedImage)image).getImage());
                    this.queueImages.put(image);
                }
                catch (InterruptedException e) {
                    logger.error(e);
                }
            }
            try {
                while (this.ex.getQueue().remainingCapacity() == 0) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
        try {
            this.writer.join();
        }
        catch (InterruptedException e) {
            logger.error(e);
        }
    }

    protected void finish() {
    }
}

