/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Function;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideSequence;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.io.download.BoundsDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideSequenceIdGenerator;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;

public final class SequenceDownloadRunnable
extends BoundsDownloadRunnable {
    private final StreetsideData data;
    private static final Function<Bounds, URL> URL_GEN = StreetsideURL.APIv3::searchStreetsideSequences;

    public SequenceDownloadRunnable(StreetsideData data, Bounds bounds) {
        super(bounds);
        this.data = data;
    }

    @Override
    public void run(URLConnection con) throws IOException {
        if (Thread.interrupted()) {
            return;
        }
        StreetsideSequence seq = new StreetsideSequence(StreetsideSequenceIdGenerator.generateId());
        ArrayList<StreetsideImage> bubbleImages = new ArrayList<StreetsideImage>();
        long startTime = System.currentTimeMillis();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            JsonParser parser = mapper.getFactory().createParser(new BufferedInputStream(con.getInputStream()));
            if (parser.nextToken() != JsonToken.START_ARRAY) {
                parser.close();
                throw new IllegalStateException("Expected an array");
            }
            StreetsideImage previous = null;
            while (parser.nextToken() == JsonToken.START_OBJECT) {
                StreetsideImage image;
                ObjectNode node = (ObjectNode)mapper.readTree(parser);
                if (node.get("id") == null || node.get("la") == null || node.get("lo") == null) continue;
                previous = image = new StreetsideImage(CubemapUtils.convertDecimal2Quaternary(node.path("id").asLong()), node.path("la").asDouble(), node.get("lo").asDouble());
                image.setAd(node.path("ad").asInt());
                image.setAl(node.path("al").asDouble());
                image.setBl(node.path("bl").asText());
                image.setCd(node.path("cd").asLong());
                image.setHe(node.path("he").asDouble());
                image.setMl(node.path("ml").asInt());
                image.setNbn(node.findValuesAsText("nbn"));
                image.setNe(node.path("ne").asLong());
                image.setPbn(node.findValuesAsText("pbn"));
                image.setPi(node.path("pi").asDouble());
                image.setPr(node.path("pr").asLong());
                image.setRo(node.path("ro").asDouble());
                ArrayList tiles = new ArrayList();
                EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> {
                    for (int i = 0; i < 4; ++i) {
                        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                            StreetsideImage tile = new StreetsideImage(String.valueOf(image.getId() + Integer.valueOf(i)));
                            tiles.add(tile);
                        }
                        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) continue;
                        for (int j = 0; j < 4; ++j) {
                            StreetsideImage tile = new StreetsideImage(String.valueOf(image.getId() + face.getValue() + CubemapUtils.rowCol2StreetsideCellAddressMap.get(String.valueOf(Integer.valueOf(i).toString() + Integer.valueOf(j).toString()))));
                            tiles.add(tile);
                        }
                    }
                });
                bubbleImages.add(image);
                logger.info("Added image with id <" + image.getId() + ">");
                if (!StreetsideProperties.PREDOWNLOAD_CUBEMAPS.get().booleanValue()) continue;
                StreetsideData.downloadSurroundingCubemaps(image);
            }
            parser.close();
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        seq.add(bubbleImages);
        if (StreetsideProperties.CUT_OFF_SEQUENCES_AT_BOUNDS.get().booleanValue()) {
            for (StreetsideAbstractImage img : seq.getImages()) {
                if (this.bounds.contains(img.getLatLon())) {
                    this.data.add(img);
                    continue;
                }
                seq.remove(img);
            }
        } else {
            boolean sequenceCrossesThroughBounds = false;
            for (int i = 0; i < seq.getImages().size() && !sequenceCrossesThroughBounds; ++i) {
                sequenceCrossesThroughBounds = this.bounds.contains(seq.getImages().get(i).getLatLon());
            }
            if (sequenceCrossesThroughBounds) {
                this.data.addAll(seq.getImages(), true);
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("Sucessfully loaded " + seq.getImages().size() + " Microsoft Streetside images in " + (endTime - startTime / 1000L));
    }

    @Override
    protected Function<Bounds, URL> getUrlGenerator() {
        return URL_GEN;
    }
}

