/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.function.Function;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class BoundsDownloadRunnable
implements Runnable {
    static final Logger logger = Logger.getLogger(BoundsDownloadRunnable.class);
    protected Bounds bounds;

    protected abstract Function<Bounds, URL> getUrlGenerator();

    public BoundsDownloadRunnable(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    public void run() {
        URL nextURL = this.getUrlGenerator().apply(this.bounds);
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("nextURL: {0}", nextURL.toString()));
        }
        try {
            while (nextURL != null) {
                if (Thread.interrupted()) {
                    logger.error(this.getClass().getSimpleName() + " for " + this.bounds.toString() + " interrupted!");
                    return;
                }
                URLConnection con = nextURL.openConnection();
                this.run(con);
                nextURL = StreetsideURL.APIv3.parseNextFromLinkHeaderValue(con.getHeaderField("Link"));
            }
        }
        catch (IOException e) {
            String message = "Could not read from URL " + nextURL.toString() + "!";
            logger.warn(message, e);
            if (!GraphicsEnvironment.isHeadless()) {
                new Notification(message).setIcon((Icon)StreetsidePlugin.LOGO.setSize(ImageProvider.ImageSizes.LARGEICON).get()).setDuration(Notification.TIME_LONG).show();
            }
            e.printStackTrace();
        }
    }

    public static void logConnectionInfo(URLConnection con, String info) throws IOException {
        StringBuilder message = con instanceof HttpURLConnection ? new StringBuilder(((HttpURLConnection)con).getRequestMethod()).append(' ').append(con.getURL()).append(" \u2192 ").append(((HttpURLConnection)con).getResponseCode()) : new StringBuilder("Download from ").append(con.getURL());
        if (info != null && info.length() >= 1) {
            message.append(" (").append(info).append(')');
        }
        logger.info(message.toString());
    }

    public abstract void run(URLConnection var1) throws IOException;
}

