/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideURL;
import us.monoid.web.Resty;

public class TileDownloadingTask
implements Callable<String> {
    static final Logger logger = Logger.getLogger(TileDownloadingTask.class);
    private String tileId;
    private final long startTime = System.currentTimeMillis();
    private StreetsideCache cache;
    protected CubemapBuilder cb;
    private final List<ITileDownloadingTaskListener> listeners = new CopyOnWriteArrayList<ITileDownloadingTaskListener>();
    boolean cancelled = false;

    public TileDownloadingTask(String id) {
        this.tileId = id;
        this.cb = CubemapBuilder.getInstance();
        this.addListener(CubemapBuilder.getInstance());
    }

    public final void addListener(ITileDownloadingTaskListener lis) {
        this.listeners.add(lis);
    }

    public String getId() {
        return this.tileId;
    }

    public void setId(String id) {
        this.tileId = id;
    }

    public StreetsideCache getCache() {
        return this.cache;
    }

    public void setCache(StreetsideCache cache) {
        this.cache = cache;
    }

    public CubemapBuilder getCb() {
        return this.cb;
    }

    public void setCb(CubemapBuilder cb) {
        this.cb = cb;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public String call() throws Exception {
        BufferedImage img = ImageIO.read(new Resty(new Resty.Option[0]).bytes(StreetsideURL.VirtualEarth.streetsideTile(this.tileId, false).toExternalForm()).stream());
        if (img == null) {
            logger.error("Download of BufferedImage " + this.tileId + " is null!");
        }
        CubemapBuilder.getInstance().getTileImages().put(this.tileId, img);
        this.fireTileAdded(this.tileId);
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            long endTime = System.currentTimeMillis();
            long runTime = (endTime - this.startTime) / 1000L;
            logger.debug(MessageFormat.format("Loaded image for {0} in {1} seconds.", this.tileId, runTime));
        }
        return this.tileId;
    }

    private void fireTileAdded(String id) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.tileAdded(id));
    }
}

