/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class CubemapUtils {
    static final Logger logger = Logger.getLogger(CubemapUtils.class);
    public static Map<String[], String> directionConversion = new HashMap<String[], String>();
    private static final int NUM_BASE = 4;
    public static final String IMPORTED_ID = "00000000";
    public static final int NUM_SIDES = 6;
    public static Map<String, String> rowCol2StreetsideCellAddressMap = null;

    public static String convertDecimal2Quaternary(long inputNum) {
        String res = null;
        StringBuilder sb = new StringBuilder();
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("convertDecimal2Quaternary input: {0}", Long.toString(inputNum)));
        }
        while (inputNum > 0L) {
            sb.append(inputNum % 4L);
            inputNum /= 4L;
        }
        res = sb.reverse().toString();
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("convertDecimal2Quaternary output: {0}", res));
        }
        return res;
    }

    public static String convertQuaternary2Decimal(String inputNum) {
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("convertQuaternary2Decimal input: {0}", inputNum));
        }
        int len = inputNum.length();
        int power = 1;
        int num = 0;
        for (int i = len - 1; i >= 0; --i) {
            if (Integer.parseInt(inputNum.substring(i, i + 1)) >= 4) {
                logger.error("Error converting quadkey " + inputNum + " to decimal.");
                return "000000000";
            }
            num += Integer.parseInt(inputNum.substring(i, i + 1)) * power;
            power *= 4;
        }
        String res = Integer.toString(num);
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("convertQuaternary2Decimal output: {0}", res));
        }
        return res;
    }

    public static String getFaceNumberForCount(int count) {
        String res;
        switch (count) {
            case 0: {
                res = CubemapFaces.FRONT.getValue();
                break;
            }
            case 1: {
                res = CubemapFaces.RIGHT.getValue();
                break;
            }
            case 2: {
                res = CubemapFaces.BACK.getValue();
                break;
            }
            case 3: {
                res = CubemapFaces.LEFT.getValue();
                break;
            }
            case 4: {
                res = CubemapFaces.UP.getValue();
                break;
            }
            case 5: {
                res = CubemapFaces.DOWN.getValue();
                break;
            }
            default: {
                res = null;
            }
        }
        return res;
    }

    public static int getTileWidth() {
        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            return 255;
        }
        return 254;
    }

    public static int getTileHeight() {
        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            return 255;
        }
        return 254;
    }

    public static int getCount4FaceNumber(String faceString) {
        int tileAddress;
        switch (faceString) {
            case "03": {
                tileAddress = 0;
                break;
            }
            case "12": {
                tileAddress = 1;
                break;
            }
            case "01": {
                tileAddress = 2;
                break;
            }
            case "10": {
                tileAddress = 3;
                break;
            }
            case "02": {
                tileAddress = 4;
                break;
            }
            case "11": {
                tileAddress = 5;
                break;
            }
            default: {
                tileAddress = 6;
            }
        }
        return tileAddress;
    }

    public static String getFaceIdFromTileId(String tileId) {
        return tileId.substring(16, 18);
    }

    public static String convertDoubleCountNrto16TileNr(String countNr) {
        String tileAddress;
        switch (countNr) {
            case "00": {
                tileAddress = "00";
                break;
            }
            case "01": {
                tileAddress = "01";
                break;
            }
            case "02": {
                tileAddress = "10";
                break;
            }
            case "03": {
                tileAddress = "11";
                break;
            }
            case "10": {
                tileAddress = "02";
                break;
            }
            case "11": {
                tileAddress = "03";
                break;
            }
            case "12": {
                tileAddress = "12";
                break;
            }
            case "13": {
                tileAddress = "13";
                break;
            }
            case "20": {
                tileAddress = "20";
                break;
            }
            case "21": {
                tileAddress = "21";
                break;
            }
            case "22": {
                tileAddress = "30";
                break;
            }
            case "23": {
                tileAddress = "31";
                break;
            }
            case "30": {
                tileAddress = "22";
                break;
            }
            case "31": {
                tileAddress = "23";
                break;
            }
            case "32": {
                tileAddress = "32";
                break;
            }
            case "33": {
                tileAddress = "33";
                break;
            }
            default: {
                tileAddress = null;
            }
        }
        return tileAddress;
    }

    static {
        rowCol2StreetsideCellAddressMap = new HashMap<String, String>();
        rowCol2StreetsideCellAddressMap.put("00", "00");
        rowCol2StreetsideCellAddressMap.put("01", "01");
        rowCol2StreetsideCellAddressMap.put("02", "10");
        rowCol2StreetsideCellAddressMap.put("03", "11");
        rowCol2StreetsideCellAddressMap.put("10", "02");
        rowCol2StreetsideCellAddressMap.put("11", "03");
        rowCol2StreetsideCellAddressMap.put("12", "12");
        rowCol2StreetsideCellAddressMap.put("13", "13");
        rowCol2StreetsideCellAddressMap.put("20", "20");
        rowCol2StreetsideCellAddressMap.put("21", "21");
        rowCol2StreetsideCellAddressMap.put("22", "30");
        rowCol2StreetsideCellAddressMap.put("23", "31");
        rowCol2StreetsideCellAddressMap.put("30", "22");
        rowCol2StreetsideCellAddressMap.put("31", "23");
        rowCol2StreetsideCellAddressMap.put("32", "32");
        rowCol2StreetsideCellAddressMap.put("33", "33");
    }

    public static enum CubemapFaces {
        FRONT("01"),
        RIGHT("02"),
        BACK("03"),
        LEFT("10"),
        UP("11"),
        DOWN("12");

        private final String value;

        public static Stream<CubemapFaces> stream() {
            return Stream.of(CubemapFaces.values());
        }

        private CubemapFaces(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum CubefaceType {
        ONE(1),
        FOUR(4),
        SIXTEEN(16);

        private final int value;
        private static Map<Integer, CubefaceType> map;

        private CubefaceType(int value) {
            this.value = value;
        }

        public static CubefaceType valueOf(int cubefaceType) {
            return map.get(cubefaceType);
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap<Integer, CubefaceType>();
            for (CubefaceType cubefaceType : CubefaceType.values()) {
                map.put(cubefaceType.value, cubefaceType);
            }
        }
    }
}

