/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideCubemap;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.TileDownloadingTask;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerPanel;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class CubemapBuilder
implements ITileDownloadingTaskListener,
StreetsideDataListener {
    static final Logger logger = Logger.getLogger(CubemapBuilder.class);
    private static CubemapBuilder instance;
    private StreetsideCubemap cubemap;
    protected boolean cancelled;
    private long startTime;
    private Map<String, BufferedImage> tileImages = new ConcurrentHashMap<String, BufferedImage>();
    private ExecutorService pool;

    public Map<String, BufferedImage> getTileImages() {
        return this.tileImages;
    }

    public void setTileImages(Map<String, BufferedImage> tileImages) {
        this.tileImages = tileImages;
    }

    private CubemapBuilder() {
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.startTime = System.currentTimeMillis();
        if (newImage != null) {
            this.cubemap = null;
            this.cubemap = new StreetsideCubemap(newImage.getId(), newImage.getLatLon(), newImage.getHe());
            this.cubemap.setCd(newImage.getCd());
            this.downloadCubemapImages(this.cubemap.getId());
            long runTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                logger.debug(MessageFormat.format("Completed downloading tiles for {0} in {1} seconds.", newImage.getId(), runTime));
            }
        }
    }

    public void reload(String imageId) {
        if (this.cubemap != null && imageId.equals(this.cubemap.getId())) {
            this.tileImages = new HashMap<String, BufferedImage>();
            this.downloadCubemapImages(imageId);
        }
    }

    public void downloadCubemapImages(String imageId) {
        if (StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getScene() != StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getLoadingScene()) {
            StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().setScene(StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getLoadingScene());
        }
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxThreadCount = 6 * maxCols * maxRows;
        int fails = 0;
        String[] message = new String[]{MessageFormat.format("Downloading Streetside imagery for {0}", imageId), "Wait for completion\u2026\u2026."};
        long startTime = System.currentTimeMillis();
        if (CubemapBuilder.getInstance().getTileImages().keySet().size() > 0) {
            this.pool.shutdownNow();
            CubemapBuilder.getInstance().resetTileImages();
        }
        try {
            this.pool = Executors.newFixedThreadPool(maxThreadCount);
            ArrayList<TileDownloadingTask> tasks = new ArrayList<TileDownloadingTask>(maxThreadCount);
            if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    int tileNr = 0;
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(tileNr++).toString());
                            tasks.add(new TileDownloadingTask(tileId));
                        }
                    }
                }
            } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    for (int j = 0; j < maxCols; ++j) {
                        for (int k = 0; k < maxRows; ++k) {
                            String tileId = String.valueOf(imageId + CubemapUtils.getFaceNumberForCount(i) + String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString()));
                            tasks.add(new TileDownloadingTask(tileId));
                        }
                    }
                }
            }
            MainApplication.worker.submit(() -> {
                try {
                    List results = this.pool.invokeAll(tasks);
                    if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                        for (Future ff : results) {
                            try {
                                logger.debug(MessageFormat.format("Completed tile downloading task {0} in {1} seconds.", ff.get(), System.currentTimeMillis() / 1000L - startTime));
                            }
                            catch (ExecutionException e) {
                                logger.error(e);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    logger.error(e);
                }
            });
        }
        catch (Exception ee) {
            ++fails;
            logger.error("Error loading tile for image " + imageId);
            ee.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        long runTime = stopTime - startTime;
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(MessageFormat.format("Tile imagery downloading tasks completed in {0} seconds.", runTime / 1000L));
        }
        if (fails > 0) {
            logger.error(Integer.valueOf(fails) + " downloading tasks failed!");
        }
    }

    @Override
    public void tileAdded(String tileId) {
        int maxRows;
        int tileCount = 0;
        tileCount = CubemapBuilder.getInstance().getTileImages().keySet().size();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int n = maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        if (tileCount == 6 * maxCols * maxRows) {
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                logger.debug(MessageFormat.format("{0} tile images ready for building cumbemap faces for cubemap {1}.", tileCount, CubemapBuilder.getInstance().getCubemap().getId()));
            }
            this.buildCubemapFaces();
        }
    }

    @Override
    public void tilesAdded(String[] tileIds) {
        int maxRows;
        int tileCount = 0;
        tileCount = CubemapBuilder.getInstance().getTileImages().keySet().size();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int n = maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        if (tileCount == 6 * maxCols * maxRows) {
            if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
                logger.debug(MessageFormat.format("{0} tile images ready for building cumbemap faces for cubemap {1}.", tileCount, CubemapBuilder.getInstance().getCubemap().getId()));
            }
            this.buildCubemapFaces();
        }
    }

    private void buildCubemapFaces() {
        int i;
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug("Assembling cubemap tile images");
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel();
        CubemapBox cmb = StreetsideViewerPanel.getCubemapBox();
        ImageView[] views = cmb.getViews();
        int maxCols = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        int maxRows = StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 4 : 2;
        Image[] finalImages = new Image[6];
        if (!StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                BufferedImage[] faceTileImages = new BufferedImage[maxCols * maxRows];
                for (int j = 0; j < maxCols * maxRows; ++j) {
                    BufferedImage currentTile;
                    String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + Integer.valueOf(j).toString());
                    faceTileImages[j] = currentTile = this.tileImages.get(tileId);
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        } else if (StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get().booleanValue()) {
            for (i = 0; i < 6; ++i) {
                int tileCount = 0;
                BufferedImage[] faceTileImages = new BufferedImage[StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get() != false ? 16 : 4];
                for (int j = 0; j < maxCols; ++j) {
                    for (int k = 0; k < maxRows; ++k) {
                        String tileId = String.valueOf(this.getCubemap().getId() + CubemapUtils.getFaceNumberForCount(i) + CubemapUtils.convertDoubleCountNrto16TileNr(String.valueOf(Integer.valueOf(j).toString() + Integer.valueOf(k).toString())));
                        BufferedImage currentTile = this.tileImages.get(tileId);
                        faceTileImages[tileCount++] = currentTile;
                    }
                }
                BufferedImage finalImg = GraphicsUtils.buildMultiTiledCubemapFaceImage(faceTileImages);
                if (i == 4) {
                    finalImg = GraphicsUtils.rotateImage(finalImg);
                }
                finalImages[i] = GraphicsUtils.convertBufferedImage2JavaFXImage(finalImg);
            }
        }
        for (i = 0; i < 6; ++i) {
            views[i].setImage(finalImages[i]);
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().revalidate();
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().repaint();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().setScene(StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getCubemapScene());
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().revalidate();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().repaint();
        long endTime = System.currentTimeMillis();
        long runTime = (endTime - this.startTime) / 1000L;
        String message = MessageFormat.format("Completed downloading, assembling and setting cubemap imagery for cubemap {0} in  {1} seconds.", this.cubemap.getId(), runTime);
        if (StreetsideProperties.DEBUGING_ENABLED.get().booleanValue()) {
            logger.debug(message);
        }
        CubemapBuilder.getInstance().resetTileImages();
    }

    private void resetTileImages() {
        this.tileImages = new HashMap<String, BufferedImage>();
    }

    public synchronized StreetsideCubemap getCubemap() {
        return this.cubemap;
    }

    public static void setCubemap(StreetsideCubemap cubemap) {
        CubemapBuilder.getInstance().cubemap = cubemap;
    }

    public static CubemapBuilder getInstance() {
        if (instance == null) {
            instance = new CubemapBuilder();
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }
}

