/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.model.UserProfile;

public class StreetsideSequence {
    private String id;
    private UserProfile user;
    private double la;
    private double lo;
    private long cd;
    private List<StreetsideAbstractImage> images;

    public StreetsideSequence(String id, Long ca) {
        this.id = id;
        this.cd = ca;
        this.images = new CopyOnWriteArrayList<StreetsideAbstractImage>();
    }

    public StreetsideSequence(String id, double la, double lo) {
        this.id = id;
        this.la = la;
        this.lo = lo;
        this.images = new CopyOnWriteArrayList<StreetsideAbstractImage>();
    }

    public StreetsideSequence() {
        this.images = new CopyOnWriteArrayList<StreetsideAbstractImage>();
    }

    public StreetsideSequence(String id, double la, double lo, long ca) {
        this.id = id;
        this.la = la;
        this.lo = lo;
        this.cd = ca;
        this.images = new CopyOnWriteArrayList<StreetsideAbstractImage>();
    }

    public StreetsideSequence(String id) {
        this.id = id;
        this.images = new CopyOnWriteArrayList<StreetsideAbstractImage>();
    }

    public synchronized void add(StreetsideAbstractImage image) {
        this.images.add(image);
        image.setSequence(this);
    }

    public synchronized void add(Collection<? extends StreetsideAbstractImage> images) {
        this.images.addAll(images);
        images.forEach(img -> img.setSequence(this));
    }

    public StreetsideAbstractImage next(StreetsideAbstractImage image) {
        int i = this.images.indexOf(image);
        if (i == -1) {
            throw new IllegalArgumentException();
        }
        if (i == this.images.size() - 1) {
            return null;
        }
        return this.images.get(i + 1);
    }

    public StreetsideAbstractImage previous(StreetsideAbstractImage image) {
        int i = this.images.indexOf(image);
        if (i < 0) {
            throw new IllegalArgumentException();
        }
        if (i == 0) {
            return null;
        }
        return this.images.get(i - 1);
    }

    public void remove(StreetsideAbstractImage image) {
        this.images.remove(image);
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getLa() {
        return this.la;
    }

    public void setLa(double la) {
        this.la = la;
    }

    public double getLo() {
        return this.lo;
    }

    public void setLo(double lo) {
        this.lo = lo;
    }

    public long getCd() {
        return this.cd;
    }

    public List<StreetsideAbstractImage> getImages() {
        return this.images;
    }

    public String getId() {
        return this.id;
    }

    public UserProfile getUser() {
        return this.user;
    }
}

