/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.IntSummaryStatistics;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.Icon;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DataSetListenerAdapter;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideImportedImage;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.history.StreetsideRecord;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideDownloader;
import org.openstreetmap.josm.plugins.streetside.mode.AbstractMode;
import org.openstreetmap.josm.plugins.streetside.mode.SelectMode;
import org.openstreetmap.josm.plugins.streetside.utils.MapViewGeometryUtil;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideColorScheme;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public final class StreetsideLayer
extends AbstractModifiableLayer
implements MainLayerManager.ActiveLayerChangeListener,
StreetsideDataListener {
    static final Logger logger = Logger.getLogger(StreetsideLayer.class);
    private static final int IMG_MARKER_RADIUS = 7;
    private static final int CA_INDICATOR_RADIUS = 15;
    private static final int CA_INDICATOR_ANGLE = 40;
    private static final DataSetListenerAdapter DATASET_LISTENER = new DataSetListenerAdapter(e -> {
        if (e instanceof DataChangedEvent && StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.OSM_AREA) {
            MainApplication.worker.execute(StreetsideDownloader::downloadOSMArea);
        }
    });
    private static StreetsideLayer instance;
    private StreetsideImage[] nearestImages = new StreetsideImage[0];
    private final StreetsideData data = new StreetsideData();
    public AbstractMode mode;
    private volatile TexturePaint hatched;

    private StreetsideLayer() {
        super(I18n.tr((String)"Microsoft Streetside Images", (Object[])new Object[0]));
        this.data.addListener(this);
    }

    private void init() {
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds != null) {
            ds.addDataSetListener((DataSetListener)DATASET_LISTENER);
        }
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        if (!GraphicsEnvironment.isHeadless()) {
            this.setMode(new SelectMode());
            if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.OSM_AREA) {
                MainApplication.worker.execute(StreetsideDownloader::downloadOSMArea);
            }
            if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.VISIBLE_AREA) {
                this.mode.zoomChanged();
            }
        }
        if (!StreetsideMainDialog.getInstance().isShowing()) {
            StreetsideMainDialog.getInstance().showDialog();
        }
        if (StreetsidePlugin.getMapView() != null) {
            StreetsideMainDialog.getInstance().streetsideImageDisplay.repaint();
        }
        this.createHatchTexture();
        this.invalidate();
    }

    public static void invalidateInstance() {
        if (StreetsideLayer.hasInstance()) {
            StreetsideLayer.getInstance().invalidate();
        }
    }

    public void setMode(AbstractMode mode) {
        MapView mv = StreetsidePlugin.getMapView();
        if (this.mode != null && mv != null) {
            mv.removeMouseListener((MouseListener)this.mode);
            mv.removeMouseMotionListener((MouseMotionListener)this.mode);
            NavigatableComponent.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this.mode);
        }
        this.mode = mode;
        if (mode != null && mv != null) {
            mv.setNewCursor(mode.cursor, (Object)this);
            mv.addMouseListener((MouseListener)mode);
            mv.addMouseMotionListener((MouseMotionListener)mode);
            NavigatableComponent.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)mode);
            StreetsideUtils.updateHelpText();
        }
    }

    private static synchronized void clearInstance() {
        instance = null;
    }

    public static synchronized StreetsideLayer getInstance() {
        if (instance != null) {
            return instance;
        }
        StreetsideLayer layer = new StreetsideLayer();
        layer.init();
        instance = layer;
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public StreetsideData getData() {
        return this.data;
    }

    public synchronized StreetsideImage getNNearestImage(int n) {
        return n >= 1 && n <= this.nearestImages.length ? this.nearestImages[n - 1] : null;
    }

    public synchronized void destroy() {
        MapView mv;
        StreetsideLayer.clearInstance();
        this.setMode(null);
        StreetsideRecord.getInstance().reset();
        AbstractMode.resetThread();
        StreetsideDownloader.stopAll();
        if (StreetsideMainDialog.hasInstance()) {
            StreetsideMainDialog.getInstance().setImage(null);
            StreetsideMainDialog.getInstance().updateImage();
        }
        if ((mv = StreetsidePlugin.getMapView()) != null) {
            mv.removeMouseListener((MouseListener)this.mode);
            mv.removeMouseMotionListener((MouseMotionListener)this.mode);
        }
        try {
            MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
            if (MainApplication.getLayerManager().getEditDataSet() != null) {
                MainApplication.getLayerManager().getEditDataSet().removeDataSetListener((DataSetListener)DATASET_LISTENER);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        super.destroy();
    }

    public boolean isModified() {
        return this.data.getImages().parallelStream().anyMatch(StreetsideAbstractImage::isModified);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.getData().getImages().parallelStream().forEach(img -> img.setVisible(visible));
    }

    private void createHatchTexture() {
        BufferedImage bi = new BufferedImage(15, 15, 2);
        Graphics2D big = bi.createGraphics();
        big.setColor(StreetsideProperties.BACKGROUND.get());
        AlphaComposite comp = AlphaComposite.getInstance(3, 0.3f);
        big.setComposite(comp);
        big.fillRect(0, 0, 15, 15);
        big.setColor(StreetsideProperties.OUTSIDE_DOWNLOADED_AREA.get());
        big.drawLine(0, 15, 15, 0);
        Rectangle r = new Rectangle(0, 0, 15, 15);
        this.hatched = new TexturePaint(bi, r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics2D g, MapView mv, Bounds box) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (MainApplication.getLayerManager().getActiveLayer() == this) {
            g.setPaint(this.hatched);
            g.fill(MapViewGeometryUtil.getNonDownloadedArea(mv, this.data.getBounds()));
        }
        Class<StreetsideLayer> clazz = StreetsideLayer.class;
        synchronized (StreetsideLayer.class) {
            StreetsideAbstractImage selectedImg = this.data.getSelectedImage();
            for (int i = 0; i < this.nearestImages.length && selectedImg != null; ++i) {
                if (i == 0) {
                    g.setColor(Color.RED);
                } else {
                    g.setColor(Color.BLUE);
                }
                Point selected = mv.getPoint(selectedImg.getMovingLatLon());
                Point p = mv.getPoint(this.nearestImages[i].getMovingLatLon());
                g.draw(new Line2D.Double(p.getX(), p.getY(), selected.getX(), selected.getY()));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (StreetsideAbstractImage imageAbs : this.data.getImages()) {
                if (!imageAbs.isVisible() || mv == null || !mv.contains(mv.getPoint(imageAbs.getMovingLatLon()))) continue;
                this.drawImageMarker(g, imageAbs);
            }
            return;
        }
    }

    private void drawImageMarker(Graphics2D g, StreetsideAbstractImage img) {
        Color directionC;
        Color markerC;
        if (img == null || img.getLatLon() == null) {
            logger.warn("An image is not painted, because it is null or has no LatLon!");
            return;
        }
        StreetsideAbstractImage selectedImg = this.getData().getSelectedImage();
        Point p = MainApplication.getMap().mapView.getPoint(img.getMovingLatLon());
        if (selectedImg != null && this.getData().getMultiSelectedImages().contains(img)) {
            markerC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_HIGHLIGHTED : StreetsideColorScheme.SEQ_HIGHLIGHTED;
            directionC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_HIGHLIGHTED_CA : StreetsideColorScheme.SEQ_HIGHLIGHTED_CA;
        } else if (selectedImg != null && selectedImg.getSequence() != null && selectedImg.getSequence().equals(img.getSequence())) {
            markerC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_SELECTED : StreetsideColorScheme.SEQ_SELECTED;
            directionC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_SELECTED_CA : StreetsideColorScheme.SEQ_SELECTED_CA;
        } else {
            markerC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_UNSELECTED : StreetsideColorScheme.SEQ_UNSELECTED;
            directionC = img instanceof StreetsideImportedImage ? StreetsideColorScheme.SEQ_IMPORTED_UNSELECTED_CA : StreetsideColorScheme.SEQ_UNSELECTED_CA;
        }
        g.setColor(directionC);
        g.fillArc(p.x - 15, p.y - 15, 30, 30, (int)(90.0 - img.getMovingHe() - 20.0), 40);
        g.setColor(markerC);
        g.fillOval(p.x - 7, p.y - 7, 14, 14);
        if (img.equals(this.getData().getHighlightedImage()) || this.getData().getMultiSelectedImages().contains(img)) {
            g.setColor(Color.WHITE);
            g.setStroke(new BasicStroke(2.0f));
            g.drawOval(p.x - 7, p.y - 7, 14, 14);
        }
    }

    public Icon getIcon() {
        return StreetsidePlugin.LOGO.setSize(ImageProvider.ImageSizes.LAYER).get();
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("This layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new LayerListPopup.InfoAction((Layer)this)};
    }

    public Object getInfoComponent() {
        IntSummaryStatistics seqSizeStats = this.getData().getSequences().stream().mapToInt(seq -> seq.getImages().size()).summaryStatistics();
        return I18n.tr((String)"Streetside layer", (Object[])new Object[0]) + '\n' + I18n.tr((String)"{0} sequences, each containing between {1} and {2} images (\u00f8 {3})", (Object[])new Object[]{this.getData().getSequences().size(), seqSizeStats.getCount() <= 0L ? 0 : seqSizeStats.getMin(), seqSizeStats.getCount() <= 0L ? 0 : seqSizeStats.getMax(), seqSizeStats.getAverage()}) + "\n\n" + I18n.tr((String)"{0} imported images", (Object[])new Object[]{this.getData().getImages().stream().filter(i -> i instanceof StreetsideImportedImage).count()}) + "\n+ " + I18n.tr((String)"{0} downloaded images", (Object[])new Object[]{this.getData().getImages().stream().filter(i -> i instanceof StreetsideImage).count()}) + "\n= " + I18n.tr((String)"{0} images in total", (Object[])new Object[]{this.getData().getImages().size()});
    }

    public String getToolTipText() {
        return I18n.tr((String)"{0} images in {1} sequences", (Object[])new Object[]{this.getData().getImages().size(), this.getData().getSequences().size()});
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        if (MainApplication.getLayerManager().getActiveLayer() == this) {
            StreetsideUtils.updateHelpText();
        }
        if (MainApplication.getLayerManager().getEditLayer() != e.getPreviousDataLayer()) {
            if (MainApplication.getLayerManager().getEditLayer() != null) {
                MainApplication.getLayerManager().getEditLayer().getDataSet().addDataSetListener((DataSetListener)DATASET_LISTENER);
            }
            if (e.getPreviousDataLayer() != null) {
                e.getPreviousDataLayer().getDataSet().removeDataSetListener((DataSetListener)DATASET_LISTENER);
            }
        }
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    @Override
    public void imagesAdded() {
        this.updateNearestImages();
    }

    @Override
    public void selectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.updateNearestImages();
    }

    private StreetsideImage[] getNearestImagesFromDifferentSequences(StreetsideAbstractImage target, int limit) {
        return (StreetsideImage[])this.data.getSequences().parallelStream().filter(seq -> seq.getId() != null && !seq.getId().equals(target.getSequence().getId())).map(seq -> {
            Optional<StreetsideAbstractImage> resImg = seq.getImages().parallelStream().filter(img -> img instanceof StreetsideImage && img.isVisible()).min(new NearestImgToTargetComparator(target));
            return resImg.orElse(null);
        }).filter(img -> img != null && img.getMovingLatLon().greatCircleDistance(target.getMovingLatLon()) < (double)StreetsideProperties.SEQUENCE_MAX_JUMP_DISTANCE.get().intValue()).sorted(new NearestImgToTargetComparator(target)).limit(limit).toArray(StreetsideImage[]::new);
    }

    private synchronized void updateNearestImages() {
        StreetsideAbstractImage selected = this.data.getSelectedImage();
        this.nearestImages = selected != null ? this.getNearestImagesFromDifferentSequences(selected, 2) : new StreetsideImage[0];
        if (MainApplication.isDisplayingMapView()) {
            // empty if block
        }
        if (this.nearestImages.length >= 1) {
            CacheUtils.downloadPicture(this.nearestImages[0]);
            if (this.nearestImages.length >= 2) {
                CacheUtils.downloadPicture(this.nearestImages[1]);
            }
        }
    }

    private static class NearestImgToTargetComparator
    implements Comparator<StreetsideAbstractImage> {
        private final StreetsideAbstractImage target;

        public NearestImgToTargetComparator(StreetsideAbstractImage target) {
            this.target = target;
        }

        @Override
        public int compare(StreetsideAbstractImage img1, StreetsideAbstractImage img2) {
            return (int)Math.signum(img1.getMovingLatLon().greatCircleDistance(this.target.getMovingLatLon()) - img2.getMovingLatLon().greatCircleDistance(this.target.getMovingLatLon()));
        }
    }
}

