/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.gui.imageinfo;

import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.openstreetmap.josm.plugins.streetside.cubemap.CameraTransformer;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;

public class ThreeSixtyDegreeViewerPanel
extends JFXPanel {
    private static final long serialVersionUID = -4940350009018422000L;
    private static Scene cubemapScene;
    private static Scene defaultScene;
    private static Group root;
    private static Group subGroup;
    private static CubemapBox cubemapBox;
    private static PerspectiveCamera camera;
    private static CameraTransformer cameraTransform;
    private static double mousePosX;
    private static double mousePosY;
    private static double mouseOldX;
    private static double mouseOldY;
    private static double mouseDeltaX;
    private static double mouseDeltaY;
    private static double cameraDistance;
    private static Image front;
    private static Image right;
    private static Image back;
    private static Image left;
    private static Image up;
    private static Image down;

    public void initialize() {
        root = new Group();
        camera = new PerspectiveCamera(true);
        cameraTransform.setTranslate(0.0, 0.0, 0.0);
        cameraTransform.getChildren().addAll((Object[])new Node[]{camera});
        camera.setNearClip(0.1);
        camera.setFarClip(1000000.0);
        camera.setFieldOfView(42.0);
        camera.setTranslateZ(-cameraDistance);
        PointLight light = new PointLight(Color.WHITE);
        cameraTransform.getChildren().add((Object)light);
        light.setTranslateX(camera.getTranslateX());
        light.setTranslateY(camera.getTranslateY());
        light.setTranslateZ(camera.getTranslateZ());
        root.getChildren().add((Object)cameraTransform);
        double size = 100000.0;
        cubemapBox = new CubemapBox(front, right, back, left, up, down, 100000.0, camera);
        subGroup = new Group();
        subGroup.getChildren().add((Object)cameraTransform);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ThreeSixtyDegreeViewerPanel.this.setScene(ThreeSixtyDegreeViewerPanel.createDefaultScene());
            }
        });
    }

    private static Scene createDefaultScene() {
        TextArea textArea = new TextArea();
        textArea.setText("No Streetside image selected.");
        VBox vbox = new VBox(new Node[]{textArea});
        root = new Group();
        camera = new PerspectiveCamera(true);
        cameraTransform.setTranslate(0.0, 0.0, 0.0);
        cameraTransform.getChildren().addAll((Object[])new Node[]{camera});
        camera.setNearClip(0.1);
        camera.setFarClip(1000000.0);
        camera.setFieldOfView(42.0);
        camera.setTranslateZ(-cameraDistance);
        PointLight light = new PointLight(Color.WHITE);
        cameraTransform.getChildren().add((Object)light);
        light.setTranslateX(camera.getTranslateX());
        light.setTranslateY(camera.getTranslateY());
        light.setTranslateZ(camera.getTranslateZ());
        root.getChildren().add((Object)cameraTransform);
        double size = 100000.0;
        cubemapBox = new CubemapBox(null, null, null, null, null, null, 100000.0, camera);
        subGroup = new Group();
        subGroup.getChildren().add((Object)cameraTransform);
        cubemapScene = new Scene((Parent)new Group(new Node[]{root}), 1024.0, 668.0, true, SceneAntialiasing.BALANCED);
        cubemapScene.setFill((Paint)Color.TRANSPARENT);
        cubemapScene.setCamera((Camera)camera);
        cubemapScene.setOnKeyPressed(event -> {
            KeyCode keycode;
            double change = 10.0;
            if (event.isShiftDown()) {
                change = 50.0;
            }
            if ((keycode = event.getCode()) == KeyCode.W) {
                camera.setTranslateZ(camera.getTranslateZ() + change);
            }
            if (keycode == KeyCode.S) {
                camera.setTranslateZ(camera.getTranslateZ() - change);
            }
            if (keycode == KeyCode.A) {
                camera.setTranslateX(camera.getTranslateX() - change);
            }
            if (keycode == KeyCode.D) {
                camera.setTranslateX(camera.getTranslateX() + change);
            }
        });
        cubemapScene.setOnMousePressed(me -> {
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseOldX = me.getSceneX();
            mouseOldY = me.getSceneY();
        });
        cubemapScene.setOnMouseDragged(me -> {
            mouseOldX = mousePosX;
            mouseOldY = mousePosY;
            mousePosX = me.getSceneX();
            mousePosY = me.getSceneY();
            mouseDeltaX = mousePosX - mouseOldX;
            mouseDeltaY = mousePosY - mouseOldY;
            double modifier = 10.0;
            double modifierFactor = 0.1;
            if (me.isControlDown()) {
                modifier = 0.1;
            }
            if (me.isShiftDown()) {
                modifier = 50.0;
            }
            if (me.isPrimaryButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.ry.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.ry.getAngle() + mouseDeltaX * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
                ThreeSixtyDegreeViewerPanel.cameraTransform.rx.setAngle(((ThreeSixtyDegreeViewerPanel.cameraTransform.rx.getAngle() - mouseDeltaY * 0.1 * modifier * 2.0) % 360.0 + 540.0) % 360.0 - 180.0);
            } else if (me.isSecondaryButtonDown()) {
                double z = camera.getTranslateZ();
                double newZ = z + mouseDeltaX * 0.1 * modifier;
                camera.setTranslateZ(newZ);
            } else if (me.isMiddleButtonDown()) {
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setX(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getX() + mouseDeltaX * 0.1 * modifier * 0.3);
                ThreeSixtyDegreeViewerPanel.cameraTransform.t.setY(ThreeSixtyDegreeViewerPanel.cameraTransform.t.getY() + mouseDeltaY * 0.1 * modifier * 0.3);
            }
        });
        root.getChildren().addAll((Object[])new Node[]{cubemapBox, subGroup});
        root.setAutoSizeChildren(true);
        subGroup.setAutoSizeChildren(true);
        Platform.setImplicitExit((boolean)false);
        defaultScene = new Scene((Parent)vbox, 200.0, 100.0);
        return defaultScene;
    }

    public CubemapBox getCubemapBox() {
        if (cubemapBox == null) {
            this.initialize();
        }
        return cubemapBox;
    }

    public Scene getDefaultScene() {
        return defaultScene;
    }

    public Scene getCubemapScene() {
        return cubemapScene;
    }

    static {
        cameraTransform = new CameraTransformer();
        cameraDistance = 5000.0;
    }
}

