/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxAbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.LinuxEventBuffer;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import java.security.AccessController;
import java.util.Arrays;

class LinuxTouchTransform {
    private LinuxInputDevice device;
    private int[] axes = new int[2];
    private double[] translates = new double[2];
    private double[] scalars = new double[2];
    private boolean flipXY;
    private int[] mins = new int[2];
    private int[] maxs = new int[2];

    LinuxTouchTransform(LinuxInputDevice device) {
        this.device = device;
        Arrays.fill(this.axes, -1);
        String product = device.getProduct();
        AccessController.doPrivileged(() -> {
            this.flipXY = Boolean.getBoolean("monocle.input." + product + ".flipXY");
            return null;
        });
    }

    int getValue(LinuxEventBuffer buffer) {
        int i;
        short axis = buffer.getEventCode();
        int value = buffer.getEventValue();
        for (i = 0; i < this.axes.length && this.axes[i] != -1; ++i) {
            if (this.axes[i] != axis) continue;
            return this.transform(i, value);
        }
        if (i == this.axes.length) {
            this.axes = Arrays.copyOf(this.axes, this.axes.length * 2);
            Arrays.fill(this.axes, i + 1, this.axes.length - 1, -1);
            this.translates = Arrays.copyOf(this.translates, this.translates.length * 2);
            this.scalars = Arrays.copyOf(this.scalars, this.scalars.length * 2);
            this.mins = Arrays.copyOf(this.mins, this.mins.length * 2);
            this.maxs = Arrays.copyOf(this.maxs, this.maxs.length * 2);
        }
        this.initTransform(axis, i);
        return this.transform(i, value);
    }

    int getAxis(LinuxEventBuffer buffer) {
        short axis = buffer.getEventCode();
        if (this.flipXY) {
            switch (axis) {
                case 0: {
                    return 1;
                }
                case 1: {
                    return 0;
                }
                case 53: {
                    return 54;
                }
                case 54: {
                    return 53;
                }
            }
            return axis;
        }
        return axis;
    }

    private void initTransform(int axis, int index) {
        String axisName;
        double range;
        switch (axis) {
            case 0: 
            case 53: {
                range = NativePlatformFactory.getNativePlatform().getScreen().getWidth();
                axisName = "X";
                break;
            }
            case 1: 
            case 54: {
                range = NativePlatformFactory.getNativePlatform().getScreen().getHeight();
                axisName = "Y";
                break;
            }
            default: {
                this.translates[index] = 0.0;
                this.scalars[index] = 1.0;
                return;
            }
        }
        LinuxAbsoluteInputCapabilities caps = this.device.getAbsoluteInputCapabilities(axis);
        String product = this.device.getProduct();
        AccessController.doPrivileged(() -> {
            int minimum = Integer.getInteger("monocle.input." + product + ".min" + axisName, caps.getMinimum());
            int maximum = Integer.getInteger("monocle.input." + product + ".max" + axisName, caps.getMaximum());
            this.translates[index] = -minimum;
            this.scalars[index] = range / (double)(maximum - minimum);
            return null;
        });
    }

    private int transform(int index, int value) {
        return (int)Math.round(((double)value + this.translates[index]) * this.scalars[index]);
    }
}

