/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.image.BufferedImage;
import javafx.animation.AnimationTimer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.PerspectiveCamera;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;

public class CubemapBox
extends Group {
    private final Affine affine = new Affine();
    private final ImageView front = new ImageView();
    private final ImageView right = new ImageView();
    private final ImageView back = new ImageView();
    private final ImageView left = new ImageView();
    private final ImageView up = new ImageView();
    private final ImageView down = new ImageView();
    private final ImageView[] views;
    private Image frontImg;
    private Image rightImg;
    private Image backImg;
    private Image leftImg;
    private Image upImg;
    private Image downImg;
    private Image singleImg;
    private final PerspectiveCamera camera;
    private AnimationTimer timer;
    private final CubemapBoxImageType imageType;
    private final DoubleProperty size;

    public CubemapBox(Image frontImg, Image rightImg, Image backImg, Image leftImg, Image upImg, Image downImg, double size, PerspectiveCamera camera) {
        this.front.setId(CubemapUtils.CubemapFaces.FRONT.getValue());
        this.right.setId(CubemapUtils.CubemapFaces.RIGHT.getValue());
        this.back.setId(CubemapUtils.CubemapFaces.BACK.getValue());
        this.left.setId(CubemapUtils.CubemapFaces.LEFT.getValue());
        this.up.setId(CubemapUtils.CubemapFaces.UP.getValue());
        this.down.setId(CubemapUtils.CubemapFaces.DOWN.getValue());
        this.views = new ImageView[]{this.front, this.right, this.back, this.left, this.up, this.down};
        this.size = new SimpleDoubleProperty(){

            protected void invalidated() {
                switch (CubemapBox.this.imageType) {
                    case SINGLE: {
                        CubemapBox.this.layoutViews();
                        break;
                    }
                }
            }
        };
        this.imageType = CubemapBoxImageType.MULTIPLE;
        this.frontImg = frontImg;
        this.rightImg = rightImg;
        this.backImg = backImg;
        this.leftImg = leftImg;
        this.upImg = upImg;
        this.downImg = downImg;
        this.size.set(size);
        this.camera = camera;
        this.loadImageViews();
        this.getTransforms().add((Object)this.affine);
        this.getChildren().addAll((Object[])this.views);
        this.startTimer();
    }

    public void loadImageViews() {
        for (ImageView iv : this.views) {
            iv.setSmooth(true);
            iv.setPreserveRatio(true);
        }
        this.validateImageType();
    }

    private void layoutViews() {
        for (ImageView v : this.views) {
            v.setFitWidth(this.getSize());
            v.setFitHeight(this.getSize());
        }
        this.back.setTranslateX(-0.5 * this.getSize());
        this.back.setTranslateY(-0.5 * this.getSize());
        this.back.setTranslateZ(-0.5 * this.getSize());
        this.front.setTranslateX(-0.5 * this.getSize());
        this.front.setTranslateY(-0.5 * this.getSize());
        this.front.setTranslateZ(0.5 * this.getSize());
        this.front.setRotationAxis(Rotate.Z_AXIS);
        this.front.setRotate(-180.0);
        this.front.getTransforms().add((Object)new Rotate(180.0, this.front.getFitHeight() / 2.0, 0.0, 0.0, Rotate.X_AXIS));
        this.front.setTranslateY(this.front.getTranslateY() - this.getSize());
        this.up.setTranslateX(-0.5 * this.getSize());
        this.up.setTranslateY(-1.0 * this.getSize());
        this.up.setRotationAxis(Rotate.X_AXIS);
        this.up.setRotate(-90.0);
        this.down.setTranslateX(-0.5 * this.getSize());
        this.down.setTranslateY(0.0);
        this.down.setRotationAxis(Rotate.X_AXIS);
        this.down.setRotate(90.0);
        this.left.setTranslateX(-1.0 * this.getSize());
        this.left.setTranslateY(-0.5 * this.getSize());
        this.left.setRotationAxis(Rotate.Y_AXIS);
        this.left.setRotate(90.0);
        this.right.setTranslateX(0.0);
        this.right.setTranslateY(-0.5 * this.getSize());
        this.right.setRotationAxis(Rotate.Y_AXIS);
        this.right.setRotate(-90.0);
    }

    private void validateImageType() {
        switch (this.imageType) {
            case SINGLE: {
                this.loadSingleImageViewports();
                break;
            }
            case MULTIPLE: {
                this.setMultipleImages();
            }
        }
    }

    private void loadSingleImageViewports() {
        this.layoutViews();
        double width = this.singleImg.getWidth();
        double height = this.singleImg.getHeight();
        if (width / 4.0 != height / 3.0) {
            throw new UnsupportedOperationException("Image does not comply with size constraints");
        }
        double cellSize = this.singleImg.getWidth() - this.singleImg.getHeight();
        this.recalculateSize(cellSize);
        double topx = cellSize;
        double topy = 0.0;
        double botx = cellSize;
        double boty = cellSize * 2.0;
        double leftx = 0.0;
        double lefty = cellSize;
        double rightx = cellSize * 2.0;
        double righty = cellSize;
        double fwdx = cellSize;
        double fwdy = cellSize;
        double backx = cellSize * 3.0;
        double backy = cellSize;
        this.up.setViewport(new Rectangle2D(topx, topy, cellSize, cellSize));
        this.left.setViewport(new Rectangle2D(leftx, lefty, cellSize - 1.0, cellSize - 1.0));
        this.front.setViewport(new Rectangle2D(fwdx, fwdy, cellSize, cellSize));
        this.right.setViewport(new Rectangle2D(rightx, righty, cellSize, cellSize));
        this.back.setViewport(new Rectangle2D(backx + 1.0, backy - 1.0, cellSize - 1.0, cellSize - 1.0));
        this.down.setViewport(new Rectangle2D(botx, boty, cellSize, cellSize));
        for (ImageView v : this.views) {
            v.setImage(this.singleImg);
        }
    }

    private void recalculateSize(double cell) {
        double factor = Math.floor(this.getSize() / cell);
        this.setSize(cell * factor);
    }

    public synchronized void setImage(BufferedImage img, int position) {
        this.views[position].setImage(GraphicsUtils.convertBufferedImage2JavaFXImage(img));
    }

    private void setMultipleImages() {
        GraphicsUtils.PlatformHelper.run(() -> {
            this.layoutViews();
            this.front.setImage(this.frontImg);
            this.right.setImage(this.rightImg);
            this.back.setImage(this.backImg);
            this.left.setImage(this.leftImg);
            this.up.setImage(this.upImg);
            this.down.setImage(this.downImg);
        });
    }

    public void startTimer() {
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                Transform ct;
                Transform transform = ct = CubemapBox.this.camera != null ? CubemapBox.this.camera.getLocalToSceneTransform() : null;
                if (ct != null) {
                    CubemapBox.this.affine.setTx(ct.getTx());
                    CubemapBox.this.affine.setTy(ct.getTy());
                    CubemapBox.this.affine.setTz(ct.getTz());
                }
            }
        };
        this.timer.start();
    }

    public final double getSize() {
        return this.size.get();
    }

    public final void setSize(double value) {
        this.size.set(value);
    }

    public DoubleProperty sizeProperty() {
        return this.size;
    }

    public ImageView[] getViews() {
        return this.views;
    }

    public static enum CubemapBoxImageType {
        MULTIPLE,
        SINGLE;

    }
}

