/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cache;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBuilder;

public final class CacheUtils {
    static final Logger logger = Logger.getLogger(CacheUtils.class);
    private static IgnoreDownload ignoreDownload = new IgnoreDownload();

    private CacheUtils() {
    }

    public static void downloadPicture(StreetsideImage img) {
        CacheUtils.downloadPicture(img, PICTURE.BOTH);
    }

    public static void downloadCubemap(StreetsideImage cm) {
        CacheUtils.downloadPicture(cm, PICTURE.CUBEMAP);
    }

    public static void downloadPicture(StreetsideImage img, PICTURE pic) {
        switch (pic) {
            case BOTH: {
                if (new StreetsideCache(img.getId(), StreetsideCache.Type.THUMBNAIL).get() == null) {
                    CacheUtils.submit(img.getId(), StreetsideCache.Type.THUMBNAIL, ignoreDownload);
                }
                if (new StreetsideCache(img.getId(), StreetsideCache.Type.FULL_IMAGE).get() != null) break;
                CacheUtils.submit(img.getId(), StreetsideCache.Type.FULL_IMAGE, ignoreDownload);
                break;
            }
            case THUMBNAIL: {
                CacheUtils.submit(img.getId(), StreetsideCache.Type.THUMBNAIL, ignoreDownload);
                break;
            }
            case FULL_IMAGE: {
                break;
            }
            case CUBEMAP: {
                if (img.getId() == null) {
                    logger.error("Download cancelled. Image id is null.");
                    break;
                }
                CubemapBuilder.getInstance().downloadCubemapImages(img.getId());
                break;
            }
            default: {
                CacheUtils.submit(img.getId(), StreetsideCache.Type.FULL_IMAGE, ignoreDownload);
            }
        }
    }

    public static void submit(String key, StreetsideCache.Type type, ICachedLoaderListener lis) {
        try {
            new StreetsideCache(key, type).submit(lis, false);
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    private static class IgnoreDownload
    implements ICachedLoaderListener {
        private IgnoreDownload() {
        }

        public void loadingFinished(CacheEntry arg0, CacheEntryAttributes arg1, ICachedLoaderListener.LoadResult arg2) {
        }
    }

    public static enum PICTURE {
        THUMBNAIL,
        FULL_IMAGE,
        BOTH,
        CUBEMAP;

    }
}

