/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.streetside.StreetsideSequence;

public abstract class StreetsideAbstractImage
implements Comparable<StreetsideAbstractImage> {
    private static final float EPSILON = 1.0E-5f;
    protected String id;
    private long ne;
    private long pr;
    private StreetsideSequence sequence;
    protected LatLon latLon;
    protected double he;
    private LatLon tempLatLon;
    private LatLon movingLatLon;
    private double tempHe;
    protected double movingHe;
    private boolean visible;

    protected StreetsideAbstractImage(String id, LatLon latLon, double he) {
        this.id = id;
        this.tempLatLon = this.latLon = latLon;
        this.movingLatLon = this.latLon;
        this.he = he;
        this.tempHe = he;
        this.movingHe = he;
        this.visible = true;
    }

    protected StreetsideAbstractImage(String id) {
        this.id = id;
        this.visible = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public double getHe() {
        return this.he;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public double getMovingHe() {
        return this.movingHe;
    }

    public LatLon getMovingLatLon() {
        return this.movingLatLon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreetsideSequence getSequence() {
        StreetsideAbstractImage streetsideAbstractImage = this;
        synchronized (streetsideAbstractImage) {
            if (this.sequence == null) {
                this.sequence = new StreetsideSequence();
                this.sequence.add(this);
            }
            return this.sequence;
        }
    }

    public double getTempHe() {
        return this.tempHe;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public boolean isModified() {
        return !this.getMovingLatLon().equals((Object)this.latLon) || Math.abs(this.getMovingHe() - this.he) > (double)1.0E-5f;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreetsideAbstractImage next() {
        StreetsideAbstractImage streetsideAbstractImage = this;
        synchronized (streetsideAbstractImage) {
            return this.getSequence().next(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreetsideAbstractImage previous() {
        StreetsideAbstractImage streetsideAbstractImage = this;
        synchronized (streetsideAbstractImage) {
            return this.getSequence().previous(this);
        }
    }

    public void setHe(double he) {
        this.he = he;
    }

    public void setLatLon(LatLon latLon) {
        if (latLon != null) {
            this.latLon = latLon;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSequence(StreetsideSequence sequence) {
        StreetsideAbstractImage streetsideAbstractImage = this;
        synchronized (streetsideAbstractImage) {
            if (sequence != null && !sequence.getImages().contains(this)) {
                throw new IllegalArgumentException();
            }
            this.sequence = sequence;
        }
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempHe = this.movingHe;
    }

    public void turn(double he) {
        this.movingHe = this.tempHe + he;
    }

    public long getNe() {
        return this.ne;
    }

    public void setNe(long ne) {
        this.ne = ne;
    }

    public long getPr() {
        return this.pr;
    }

    public void setPr(long pr) {
        this.pr = pr;
    }
}

