/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifEllipsoid;

public enum MifDatum {
    ADINDAN(1, "Ethiopia, Mali, Senegal, Sudan", MifEllipsoid.CLARKE_1880),
    AFGOOYE(2, "Somalia", MifEllipsoid.KRASSOVSKY),
    AIN_EL_ABD_1970(3, "Bahrain Island", MifEllipsoid.INTERNATIONAL),
    ANNA_1_ASTRO_1965(4, "Cocos Islands", MifEllipsoid.AUSTRALIAN_NATIONAL),
    ARC_1950(5, "Botswana, Lesotho, Malawi, Swaziland, Zaire, Zambia, Zimbabwe", MifEllipsoid.CLARKE_1880),
    ARC_1960(6, "Kenya, Tanzania", MifEllipsoid.CLARKE_1880),
    ASCENSION_ISLAND_1958(7, "Ascension Island", MifEllipsoid.INTERNATIONAL),
    ASTRO_BEACON_E(8, "Iwo Jima Island", MifEllipsoid.INTERNATIONAL),
    ASTRO_B4_SOROL_ATOLL(9, "Tern Island", MifEllipsoid.INTERNATIONAL),
    ASTRO_DOS_71_4(10, "St. Helena Island", MifEllipsoid.INTERNATIONAL),
    ASTRONOMIC_STATION_1952(11, "Marcus Island", MifEllipsoid.INTERNATIONAL),
    AUSTRALIAN_GEODETIC_1966_AGD_66(12, "Australia and Tasmania Island", MifEllipsoid.AUSTRALIAN_NATIONAL),
    AUSTRALIAN_GEODETIC_1984_AGD_84(13, "Australia and Tasmania Island", MifEllipsoid.AUSTRALIAN_NATIONAL),
    BELGIUM(110, "Belgium", MifEllipsoid.INTERNATIONAL),
    BELLEVUE_IGN(14, "Efate and Erromango Islands", MifEllipsoid.INTERNATIONAL),
    BERMUDA_1957(15, "Bermuda Islands", MifEllipsoid.CLARKE_1866),
    BOGOTA_OBSERVATORY(16, "Colombia", MifEllipsoid.INTERNATIONAL),
    CAMPO_INCHAUSPE(17, "Argentina", MifEllipsoid.INTERNATIONAL),
    CANTON_ASTRO_1966(18, "Phoenix Islands", MifEllipsoid.INTERNATIONAL),
    CAPE(19, "South Africa", MifEllipsoid.CLARKE_1880),
    CAPE_CANAVERAL(20, "Florida and Bahama Islands", MifEllipsoid.CLARKE_1866),
    CARTHAGE(21, "Tunisia", MifEllipsoid.CLARKE_1880),
    CHATHAM_1971(22, "Chatham Island (New Zealand)", MifEllipsoid.INTERNATIONAL),
    CHUA_ASTRO(23, "Paraguay", MifEllipsoid.INTERNATIONAL),
    CORREGO_ALEGRE(24, "Brazil", MifEllipsoid.INTERNATIONAL),
    DEUTSCHES_HAUPTDREICKSNETZ_DHDN(1000, "Germany", MifEllipsoid.BESSEL),
    DJAKARTA_BATAVIA(25, "Sumatra Island (Indonesia)", MifEllipsoid.BESSEL_1841),
    DOS_1968(26, "Gizo Island (New Georgia Islands)", MifEllipsoid.INTERNATIONAL),
    EASTER_ISLAND_1967(27, "Easter Island", MifEllipsoid.INTERNATIONAL),
    EUROPEAN_1950_ED_50(28, "Austria, Belgium, Denmark, Finland, France, Germany, Gibraltar, Greece, Italy, Luxembourg, Netherlands, Norway, Portugal, Spain, Sweden, Switzerland", MifEllipsoid.INTERNATIONAL),
    EUROPEAN_1979_ED_79(29, "Austria, Finland, Netherlands, Norway, Spain, Sweden, Switzerland", MifEllipsoid.INTERNATIONAL),
    EUROPEAN_1987_ED_87(108, "Europe", MifEllipsoid.INTERNATIONAL),
    GANDAJIKA_BASE(30, "Republic of Maldives", MifEllipsoid.INTERNATIONAL),
    GEODETIC_DATUM_1949(31, "New Zealand", MifEllipsoid.INTERNATIONAL),
    GEODETIC_REFERENCE_SYSTEM_1967_GRS_67(32, "Worldwide", MifEllipsoid.GRS_67),
    GEODETIC_REFERENCE_SYSTEM_1980_GRS_80(33, "Worldwide", MifEllipsoid.GRS_80),
    GUAM_1963(34, "Guam Island", MifEllipsoid.CLARKE_1866),
    GUX_1_ASTRO(35, "Guadalcanal Island", MifEllipsoid.INTERNATIONAL),
    HITO_XVIII_1963(36, "South Chile (near 53\u00b0S)", MifEllipsoid.INTERNATIONAL),
    HJORSEY_1955(37, "Iceland", MifEllipsoid.INTERNATIONAL),
    HONG_KONG_1963(38, "Hong Kong", MifEllipsoid.INTERNATIONAL),
    HU_TZU_SHAN(39, "Taiwan", MifEllipsoid.INTERNATIONAL),
    INDIAN_40(40, "Thailand and Vietnam", MifEllipsoid.EVEREST),
    INDIAN_41(41, "Bangladesh, India, Nepal", MifEllipsoid.EVEREST),
    IRELAND_1965(42, "Ireland", MifEllipsoid.MODIFIED_AIRY),
    ISTS_073_ASTRO_1969(43, "Diego Garcia", MifEllipsoid.INTERNATIONAL),
    JOHNSTON_ISLAND_1961(44, "Johnston Island", MifEllipsoid.INTERNATIONAL),
    KANDAWALA(45, "Sri Lanka", MifEllipsoid.EVEREST),
    KERGUELEN_ISLAND(46, "Kerguelen Island", MifEllipsoid.INTERNATIONAL),
    KERTAU_1948(47, "West Malaysia and Singapore", MifEllipsoid.MODIFIED_EVEREST),
    LC_5_ASTRO(48, "Cayman Brac Island", MifEllipsoid.CLARKE_1866),
    LIBERIA_1964(49, "Liberia", MifEllipsoid.CLARKE_1880),
    LISBOA_DLX(113, "Portugal", MifEllipsoid.INTERNATIONAL),
    LUZON_50(50, "Philippines (excluding Mindanao Island)", MifEllipsoid.CLARKE_1866),
    LUZON_51(51, "Mindanao Island", MifEllipsoid.CLARKE_1866),
    MAHE_1971(52, "Mahe Island", MifEllipsoid.CLARKE_1880),
    MARCO_ASTRO(53, "Salvage Islands", MifEllipsoid.INTERNATIONAL),
    MASSAWA(54, "Eritrea (Ethiopia)", MifEllipsoid.BESSEL_1841),
    MELRICA_1973_D73(114, "Portugal", MifEllipsoid.INTERNATIONAL),
    MERCHICH(55, "Morocco", MifEllipsoid.CLARKE_1880),
    MIDWAY_ASTRO_1961(56, "Midway Island", MifEllipsoid.INTERNATIONAL),
    MINNA(57, "Nigeria", MifEllipsoid.CLARKE_1880),
    NAHRWAN_58(58, "Masirah Island (Oman)", MifEllipsoid.CLARKE_1880),
    NAHRWAN_59(59, "United Arab Emirates", MifEllipsoid.CLARKE_1880),
    NAHRWAN_60(60, "Saudi Arabia", MifEllipsoid.CLARKE_1880),
    NAPARIMA_BWI(61, "Trinidad and Tobago", MifEllipsoid.INTERNATIONAL),
    NETHERLANDS(109, "Netherlands", MifEllipsoid.BESSEL),
    NORTH_AMERICAN_1927_NAD_27_CONTINENTAL(62, "Continental US", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_ALASKA(63, "Alaska", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_BAHAMAS(64, "Bahamas (excluding San Salvador Island)", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_SAN_SALVADOR(65, "San Salvador Island", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_CANADA(66, "Canada (including Newfoundland Island)", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_CANAL_ZONE(67, "Canal Zone", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_CARIBBEAN(68, "Caribbean (Turks and Caicos Islands)", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_CENTRAL_AMERICA(69, "Central America (Belize, Costa Rica, El Salvador, Guatemala, Honduras, Nicaragua)", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_CUBA(70, "Cuba", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_GREENLAND(71, "Greenland (Hayes Peninsula)", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_MEXICO(72, "Mexico", MifEllipsoid.CLARKE_1866),
    NORTH_AMERICAN_1927_NAD_27_MICHIGAN(73, "Michigan (used only for State Plane Coordinate System 1927)", MifEllipsoid.MODIFIED_CLARKE_1866),
    NORTH_AMERICAN_1983_NAD_83(74, "Alaska, Canada, Central America, Continental US, Mexico", MifEllipsoid.GRS_80),
    NOUVELLE_TRIANGULATION_FRANCAISE_NTF(107, "France", MifEllipsoid.CLARKE_1880),
    NOUVELLE_TRIANGULATION_FRANCAISE_NTF_GREENWICH_PRIME_MERIDIAN(1002, "France", MifEllipsoid.CLARKE_1880),
    NWGL_10(111, "Worldwide", MifEllipsoid.WGS_72),
    OBSERVATORIO_1966(75, "Corvo and Flores Islands (Azores)", MifEllipsoid.INTERNATIONAL),
    OLD_EGYPTIAN(76, "Egypt", MifEllipsoid.HELMERT_1906),
    OLD_HAWAIIAN(77, "Hawaii", MifEllipsoid.CLARKE_1866),
    OMAN(78, "Oman", MifEllipsoid.CLARKE_1880),
    ORDNANCE_SURVEY_OF_GREAT_BRITAIN_1936(79, "England, Isle of Man, Scotland, Shetland Islands, Wales", MifEllipsoid.AIRY),
    PICO_DE_LAS_NIEVES(80, "Canary Islands", MifEllipsoid.INTERNATIONAL),
    PITCAIRN_ASTRO_1967(81, "Pitcairn Island", MifEllipsoid.INTERNATIONAL),
    POTSDAM(1000, "Germany", MifEllipsoid.BESSEL),
    PROVISIONAL_SOUTH_CHILEAN_1963(36, "South Chile (near 53\u00b0S)", MifEllipsoid.INTERNATIONAL),
    PROVISIONAL_SOUTH_AMERICAN_1956(82, "Bolivia, Chile, Colombia, Ecuador, Guyana, Peru, Venezuela", MifEllipsoid.INTERNATIONAL),
    PUERTO_RICO(83, "Puerto Rico and Virgin Islands", MifEllipsoid.CLARKE_1866),
    PULKOVO_1942(1001, "Germany", MifEllipsoid.KRASSOVSKY),
    QATAR_NATIONAL(84, "Qatar", MifEllipsoid.INTERNATIONAL),
    QORNOQ(85, "South Greenland", MifEllipsoid.INTERNATIONAL),
    RAUENBERG(1000, "Germany", MifEllipsoid.BESSEL),
    REUNION(86, "Mascarene Island", MifEllipsoid.INTERNATIONAL),
    RIKETS_TRIANGULERING_1990_RT_90(112, "Sweden", MifEllipsoid.BESSEL),
    ROME_1940(87, "Sardinia Island", MifEllipsoid.INTERNATIONAL),
    SANTO_DOS(88, "Espirito Santo Island", MifEllipsoid.INTERNATIONAL),
    SAO_BRAZ(89, "S\u00e3o Miguel, Santa Maria Islands (Azores)", MifEllipsoid.INTERNATIONAL),
    SAPPER_HILL_1943(90, "East Falkland Island", MifEllipsoid.INTERNATIONAL),
    SCHWARZECK(91, "Namibia Modified", MifEllipsoid.BESSEL_1841),
    SOUTH_AMERICAN_1969(92, "Argentina, Bolivia, Brazil, Chile, Colombia, Ecuador, Guyana, Paraguay, Peru, Venezuela, Trinidad, and Tobago", MifEllipsoid.SOUTH_AMERICAN_1969),
    SOUTH_ASIA(93, "Singapore", MifEllipsoid.MODIFIED_FISCHER_1960),
    SOUTHEAST_BASE(94, "Porto Santo and Madeira Islands", MifEllipsoid.INTERNATIONAL),
    SOUTHWEST_BASE(95, "Faial, Graciosa, Pico, Sao Jorge, Terceira Islands (Azores)", MifEllipsoid.INTERNATIONAL),
    SWITZERLAND_CH_1903(1003, "Switzerland", MifEllipsoid.BESSEL),
    TIMBALAI_1948(96, "Brunei and East Malaysia (Sarawak and Sabah)", MifEllipsoid.EVEREST),
    TOKYO(97, "Japan, Korea, Okinawa", MifEllipsoid.BESSEL_1841),
    TRISTAN_ASTRO_1968(98, "Tristan da Cunha", MifEllipsoid.INTERNATIONAL),
    VITI_LEVU_1916(99, "Viti Levu Island (Fiji Islands)", MifEllipsoid.CLARKE_1880),
    WAKE_ENIWETOK_1960(100, "", MifEllipsoid.HOUGH),
    WORLD_GEODETIC_SYSTEM_1960_WGS_60(101, "", MifEllipsoid.WGS_60),
    WORLD_GEODETIC_SYSTEM_1966_WGS_66(102, "", MifEllipsoid.WGS_66),
    WORLD_GEODETIC_System_1972_WGS_72(103, "", MifEllipsoid.WGS_72),
    WORLD_GEODETIC_System_1984_WGS_84(104, "", MifEllipsoid.WGS_84),
    YACARE(105, "", MifEllipsoid.INTERNATIONAL),
    ZANDERIJ(106, "", MifEllipsoid.INTERNATIONAL),
    CUSTOM(999, null, null);

    private final Integer code;
    private final String area;
    private final MifEllipsoid ellipsoid;

    private MifDatum(Integer code, String area, MifEllipsoid ellipsoid) {
        this.code = code;
        this.area = area;
        this.ellipsoid = ellipsoid;
    }

    public final Integer getCode() {
        return this.code;
    }

    public final String getArea() {
        return this.area;
    }

    public final MifEllipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public static MifDatum forCode(Integer code) {
        for (MifDatum p : MifDatum.values()) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }
}

