/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.tasks;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import net.ggtools.grand.log.LoggerManager;
import net.ggtools.grand.tasks.GraphFilterType;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

final class GraphFilterFactory {
    private static final Log LOG = LoggerManager.getLog(GraphFilterFactory.class);
    static final Properties CONFIGURATION = new Properties();

    GraphFilterFactory() {
    }

    GraphFilterType getFilterType(Project project, String name) {
        GraphFilterType filter;
        Constructor<?> constructor;
        Class<?> filterClass;
        project.log("Creating filter for name " + name, 4);
        String filterClassName = CONFIGURATION.getProperty(name);
        if (filterClassName == null) {
            throw new BuildException("Filter " + name + " not configured");
        }
        project.log("Using " + filterClassName, 4);
        try {
            filterClass = Class.forName(filterClassName);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Cannot find filter class", (Throwable)e);
        }
        try {
            constructor = filterClass.getConstructor(Project.class);
        }
        catch (SecurityException e) {
            String message = "Cannot access constructor for class " + filterClassName;
            project.log(message, 0);
            throw new BuildException(message, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            String message = "Cannot find constructor for class " + filterClassName;
            project.log(message, 0);
            throw new BuildException(message, (Throwable)e);
        }
        try {
            filter = (GraphFilterType)constructor.newInstance(project);
        }
        catch (IllegalArgumentException e) {
            throw new BuildException("Cannot instantiate filter", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException("Cannot instantiate filter", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException("Cannot instantiate filter", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new BuildException("Cannot instantiate filter", (Throwable)e);
        }
        return filter;
    }

    static {
        try {
            CONFIGURATION.load(GraphFilterFactory.class.getResourceAsStream("GraphFilterFactory.properties"));
        }
        catch (IOException e) {
            LOG.error("Cannot read properties", e);
            throw new RuntimeException(e);
        }
    }
}

