/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.ggtools.grand.ant.AntProject;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.filters.GraphFilter;
import net.ggtools.grand.graph.GraphProducer;
import net.ggtools.grand.log.AntLog;
import net.ggtools.grand.output.DotWriter;
import net.ggtools.grand.tasks.FilterType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.PropertySet;

public class GrandTask
extends Task {
    private static final String DEFAULT_OUTCONFIG_PREFIX = "dot";
    private File buildFile;
    private File output;
    private File outputConfigurationFile;
    private String outputConfigurationPrefix;
    private final List<PropertySet> propertySets = new ArrayList<PropertySet>();
    private final List<FilterType> filters = new LinkedList<FilterType>();
    private boolean showGraphName = false;
    private boolean inheritAll = false;
    private final List<Property> properties = new LinkedList<Property>();

    private void checkParams() {
        if (this.output == null) {
            String message = "required attribute missing";
            this.log("required attribute missing", 0);
            throw new BuildException("required attribute missing");
        }
        if (this.outputConfigurationFile != null && this.outputConfigurationPrefix != null) {
            String message = "cannot specify both outputconfigfile and outputconfigprefix";
            this.log("cannot specify both outputconfigfile and outputconfigprefix", 0);
            throw new BuildException("cannot specify both outputconfigfile and outputconfigprefix");
        }
        for (FilterType filter : this.filters) {
            filter.checkParameters();
        }
    }

    public final void execute() {
        this.checkParams();
        GraphProducer graphProject = this.initAntProject();
        this.log("Done loading project ", 3);
        this.log("Setting up filter chain");
        GraphProducer producer = graphProject;
        int numFilters = 0;
        for (FilterType filterType : this.filters) {
            this.log("Adding filter " + filterType.getFilterName(), 3);
            GraphFilter filter = filterType.getFilter();
            filter.setProducer(producer);
            producer = filter;
            ++numFilters;
        }
        if (numFilters > 0) {
            this.log("Loaded " + numFilters + " filter" + (numFilters > 1 ? "s" : ""));
        }
        try {
            Properties override = null;
            if (this.outputConfigurationFile != null) {
                this.log("Overriding default output configuration from " + this.outputConfigurationFile);
                override = new Properties();
                override.load(new FileInputStream(this.outputConfigurationFile));
            }
            if (this.outputConfigurationPrefix != null) {
                this.log("Overriding default output configuration from project properties " + this.outputConfigurationPrefix + ".*");
                override = new Properties();
                for (String property : this.getProject().getProperties().keySet()) {
                    if (!property.startsWith(this.outputConfigurationPrefix)) continue;
                    override.put(property.replace(this.outputConfigurationPrefix, DEFAULT_OUTCONFIG_PREFIX), this.getProject().getProperty(property).replaceAll("'", "\""));
                }
            }
            DotWriter dotWriter = new DotWriter(override);
            dotWriter.setProducer(producer);
            dotWriter.setShowGraphName(this.showGraphName);
            this.log("Writing output to " + this.output);
            dotWriter.write(this.output);
        }
        catch (IOException e) {
            this.log("Cannot write graph", 0);
            throw new BuildException("Cannot write graph", (Throwable)e);
        }
        catch (GrandException e) {
            this.log("Cannot process graph", 0);
            throw new BuildException("Cannot write graph", (Throwable)e);
        }
    }

    private GraphProducer initAntProject() {
        Project antProject;
        if (this.buildFile == null) {
            this.log("Using current project");
            antProject = this.getProject();
        } else {
            this.log("Loading project " + this.buildFile);
            antProject = this.loadNewProject();
        }
        for (PropertySet ps : this.propertySets) {
            this.addAlmostAll(antProject, ps.getProperties());
        }
        if (this.properties.size() > 0) {
            for (Property prop : this.properties) {
                prop.setProject(antProject);
                prop.setTaskName("property");
                prop.execute();
            }
        }
        return new AntProject(antProject);
    }

    private Project loadNewProject() {
        Project antProject = new Project();
        for (BuildListener listener : this.getProject().getBuildListeners()) {
            antProject.addBuildListener(listener);
        }
        antProject.init();
        if (!this.inheritAll) {
            antProject.setSystemProperties();
        } else {
            Properties props = new Properties();
            for (Map.Entry entry : this.getProject().getProperties().entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
            this.addAlmostAll(antProject, props);
        }
        antProject.setUserProperty("ant.file", this.buildFile.getAbsolutePath());
        ProjectHelper loader = ProjectHelper.getProjectHelper();
        antProject.addReference("ant.projectHelper", (Object)loader);
        loader.parse(antProject, (Object)this.buildFile);
        this.getProject().copyUserProperties(antProject);
        return antProject;
    }

    public final void setProject(Project project) {
        super.setProject(project);
        AntLog.setCurrentProject(project);
        AntLog.setCurrentTask(this);
    }

    public final void setBuildFile(File file) {
        this.buildFile = file;
    }

    public final void setOutput(File file) {
        this.output = file;
    }

    @Deprecated
    public final void setPropertyFile(File propertyFile) {
        this.log("Using of deprecated \"propertyfile\" attribute, use \"outputconfigfile\" from now on", 1);
        this.outputConfigurationFile = propertyFile;
    }

    public final void setOutputConfigFile(File propertyFile) {
        this.outputConfigurationFile = propertyFile;
    }

    public final void setOutputConfigPrefix(String propertyPrefix) {
        if (propertyPrefix == null) {
            return;
        }
        if ("".equals(propertyPrefix)) {
            this.outputConfigurationPrefix = DEFAULT_OUTCONFIG_PREFIX;
            return;
        }
        this.outputConfigurationPrefix = propertyPrefix;
    }

    public final void setShowGraphName(boolean show) {
        this.showGraphName = show;
    }

    public final void setInheritAll(boolean value) {
        this.inheritAll = value;
    }

    public final void addFilter(FilterType filter) {
        this.filters.add(filter);
    }

    public final void addProperty(Property p) {
        this.properties.add(p);
    }

    public final void addPropertyset(PropertySet ps) {
        this.propertySets.add(ps);
    }

    private void addAlmostAll(Project destProject, Properties props) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement().toString();
            if ("basedir".equals(key) || "ant.file".equals(key)) continue;
            String value = props.get(key).toString();
            if (destProject.getProperty(key) != null) continue;
            destProject.setNewProperty(key, value);
        }
    }
}

