/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.tasks;

import net.ggtools.grand.filters.GraphFilter;
import net.ggtools.grand.tasks.GraphFilterFactory;
import net.ggtools.grand.tasks.GraphFilterType;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class FilterType {
    private static final GraphFilterFactory FILTER_FACTORY = new GraphFilterFactory();
    private GraphFilterType filter;
    private String filterName;
    private String nodeName;
    private final Project project;

    public FilterType(Project prj) {
        this.project = prj;
    }

    private void checkFilter() {
        if (this.filter == null) {
            this.filter = FILTER_FACTORY.getFilterType(this.project, this.filterName);
            if (this.nodeName != null) {
                this.filter.setNodeName(this.nodeName);
            }
        }
    }

    final void checkParameters() {
        if (this.filterName == null) {
            String message = "required attribute missing";
            this.project.log("required attribute missing", 0);
            throw new BuildException("required attribute missing");
        }
        this.checkFilter();
        this.filter.checkParameters();
    }

    public final GraphFilter getFilter() {
        this.checkFilter();
        return this.filter.getFilter();
    }

    public final void setName(String name) {
        this.filterName = name;
    }

    public final void setNode(String node) {
        this.nodeName = node;
    }

    public final String getFilterName() {
        return this.filterName;
    }
}

