/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.output;

import java.util.Collection;
import net.ggtools.grand.Configuration;
import net.ggtools.grand.ant.AntLink;
import net.ggtools.grand.ant.AntTargetNode;
import net.ggtools.grand.ant.AntTaskLink;
import net.ggtools.grand.ant.SubantTaskLink;
import net.ggtools.grand.graph.Link;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.graph.visit.LinkVisitor;
import net.ggtools.grand.graph.visit.NodeVisitor;
import net.ggtools.grand.log.LoggerManager;
import net.ggtools.grand.output.DotWriterOutput;
import org.apache.commons.logging.Log;

class DotWriterVisitor
implements NodeVisitor {
    private static final String DOT_GRAPH_ATTRIBUTES = "dot.graph.attributes";
    private static final String DOT_LINK_ATTRIBUTES = "dot.link.attributes";
    private static final String DOT_MAINNODE_ATTRIBUTES = "dot.mainnode.attributes";
    private static final String DOT_MISSINGNODE_ATTRIBUTES = "dot.missingnode.attributes";
    private static final String DOT_NODE_ATTRIBUTES = "dot.node.attributes";
    private static final String DOT_STARTNODE_ATTRIBUTES = "dot.startnode.attributes";
    private static final String DOT_SUBANTLINK_ATTRIBUTES = "dot.subantlink.attributes";
    private static final String DOT_WEAK_LINK_ATTRIBUTES = "dot.weaklink.attributes";
    private static final Log LOG = LoggerManager.getLog(DotWriterVisitor.class);
    private final Configuration config;
    private final String graphAttributes;
    private final String linkAttributes;
    private final String mainNodeAttributes;
    private final String missingNodeAttributes;
    private final String nodeAttributes;
    private final DotWriterOutput output;
    private final String startNodeAttributes;
    private final String subantLinkAttributes;
    private final String weakLinkAttributes;

    DotWriterVisitor(DotWriterOutput output, Configuration config) {
        this.output = output;
        this.config = config;
        this.graphAttributes = config.get(DOT_GRAPH_ATTRIBUTES);
        this.linkAttributes = config.get(DOT_LINK_ATTRIBUTES);
        this.weakLinkAttributes = config.get(DOT_WEAK_LINK_ATTRIBUTES);
        this.subantLinkAttributes = config.get(DOT_SUBANTLINK_ATTRIBUTES);
        this.mainNodeAttributes = config.get(DOT_MAINNODE_ATTRIBUTES);
        this.missingNodeAttributes = config.get(DOT_MISSINGNODE_ATTRIBUTES);
        this.nodeAttributes = config.get(DOT_NODE_ATTRIBUTES);
        this.startNodeAttributes = config.get(DOT_STARTNODE_ATTRIBUTES);
    }

    @Override
    public void visitNode(AntTargetNode node) {
        this.visitNode((Node)node);
    }

    @Override
    public void visitNode(Node node) {
        this.output.append("\"").appendEscaped(node.getName()).append("\"");
        String attributes = null;
        if (node.hasAttributes(8)) {
            attributes = this.startNodeAttributes;
        } else if (node.hasAttributes(1)) {
            attributes = this.mainNodeAttributes;
        } else if (node.hasAttributes(2)) {
            attributes = this.missingNodeAttributes;
        }
        String description = node.getDescription();
        if (attributes != null || description != null) {
            this.output.append(" [");
            if (attributes != null) {
                this.output.append(attributes);
            }
            if (description != null) {
                if (attributes != null) {
                    this.output.append(",");
                }
                this.output.append("comment=\"").appendEscaped(description).append("\"");
            }
            this.output.append("];");
        }
        this.output.newLine();
        Collection<Link> deps = node.getLinks();
        NodeLinksVisitor linkVisitor = new NodeLinksVisitor(node);
        for (Link link : deps) {
            link.accept(linkVisitor);
        }
        this.output.newLine();
    }

    private final class NodeLinksVisitor
    implements LinkVisitor {
        private final Node node;
        private final String nodeInfo;
        private final int numDeps;
        private int visitedLinks;

        private NodeLinksVisitor(Node node) {
            this.node = node;
            this.nodeInfo = node.getName();
            this.numDeps = node.getLinks().size();
            this.visitedLinks = 0;
        }

        @Override
        public void visitLink(AntLink link) {
            this.visitLink((Link)link);
        }

        @Override
        public void visitLink(AntTaskLink link) {
            this.visitLink((Link)link);
        }

        @Override
        public void visitLink(Link link) {
            String attributes = null;
            if (link.hasAttributes(1)) {
                attributes = DotWriterVisitor.this.weakLinkAttributes;
            }
            this.outputOneLink(link, attributes);
        }

        @Override
        public void visitLink(SubantTaskLink link) {
            this.outputOneLink(link, DotWriterVisitor.this.subantLinkAttributes, link.getDirectories().size());
        }

        private void outputOneLink(Link link, String attributes) {
            this.outputOneLink(link, attributes, 1);
        }

        private void outputOneLink(Link link, String attributes, int visits) {
            ++this.visitedLinks;
            Node depNode = link.getEndNode();
            DotWriterVisitor.this.output.append("\"").appendEscaped(this.nodeInfo).append("\"").append(" -> \"").appendEscaped(depNode.getName()).append("\"");
            if (this.numDeps > 1 || visits > 1 || attributes != null) {
                DotWriterVisitor.this.output.append(" [");
                if (this.numDeps > 1 || visits > 1) {
                    DotWriterVisitor.this.output.append("label=\"").append(this.visitedLinks);
                    if (visits > 1) {
                        this.visitedLinks += visits - 1;
                        DotWriterVisitor.this.output.append("-").append(this.visitedLinks);
                    }
                    DotWriterVisitor.this.output.append("\"");
                }
                if (attributes != null) {
                    if (this.numDeps > 1 || visits > 1) {
                        DotWriterVisitor.this.output.append(", ");
                    }
                    DotWriterVisitor.this.output.append(attributes);
                }
                DotWriterVisitor.this.output.append("]");
            }
            DotWriterVisitor.this.output.append(";").newLine();
        }
    }
}

