/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.output;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Properties;
import net.ggtools.grand.Configuration;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphProducer;
import net.ggtools.grand.graph.GraphWriter;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.log.LoggerManager;
import net.ggtools.grand.output.DotWriterOutput;
import net.ggtools.grand.output.DotWriterVisitor;
import org.apache.commons.logging.Log;

public class DotWriter
implements GraphWriter {
    private static final Log LOG = LoggerManager.getLog(DotWriter.class);
    private static final String DOT_GRAPH_ATTRIBUTES = "dot.graph.attributes";
    private static final String DOT_LINK_ATTRIBUTES = "dot.link.attributes";
    private static final String DOT_NODE_ATTRIBUTES = "dot.node.attributes";
    private String graphAttributes;
    private String linkAttributes;
    private String nodeAttributes;
    private final Configuration config;
    private GraphProducer graphProducer;
    private boolean showGraphName;

    public DotWriter() throws IOException {
        this(null);
    }

    public DotWriter(Properties override) throws IOException {
        this.config = Configuration.getConfiguration(override);
        this.graphAttributes = this.config.get(DOT_GRAPH_ATTRIBUTES);
        this.linkAttributes = this.config.get(DOT_LINK_ATTRIBUTES);
        this.nodeAttributes = this.config.get(DOT_NODE_ATTRIBUTES);
    }

    @Override
    public final void write(File output) throws IOException, GrandException {
        LOG.info("Outputting to " + output);
        FileOutputStream oStream = new FileOutputStream(output);
        this.write(oStream);
        oStream.flush();
        oStream.close();
    }

    @Override
    public final void write(OutputStream stream) throws GrandException {
        Output output = new Output(stream);
        Graph graph = this.graphProducer.getGraph();
        output.append("digraph \"").appendEscaped(graph.getName()).append("\" {").newLine();
        output.append("graph [").append(this.graphAttributes);
        if (this.showGraphName) {
            output.append(",label=\"").append(graph.getName()).append("\"");
        }
        output.append("];").newLine();
        output.append("node [").append(this.nodeAttributes).append("];").newLine();
        output.append("edge [").append(this.linkAttributes).append("];").newLine();
        DotWriterVisitor visitor = new DotWriterVisitor(output, this.config);
        Node startNode = graph.getStartNode();
        if (startNode != null) {
            startNode.accept(visitor);
        }
        Iterator<Node> iter = graph.getNodes();
        while (iter.hasNext()) {
            Node node = iter.next();
            if (node.equals(startNode) || node.getName().equals("")) continue;
            node.accept(visitor);
        }
        output.append("}").newLine();
        output.close();
    }

    @Override
    public final void setProducer(GraphProducer producer) {
        this.graphProducer = producer;
    }

    @Override
    public final void setShowGraphName(boolean show) {
        this.showGraphName = show;
    }

    private static final class Output
    implements DotWriterOutput {
        private final PrintWriter writer;

        private static String escapeString(String str) {
            if (str == null) {
                return null;
            }
            return str.replaceAll("(\\\"\\s)", "\\\\\\1");
        }

        private Output(OutputStream stream) {
            this.writer = new PrintWriter(stream);
        }

        @Override
        public DotWriterOutput append(String strValue) {
            this.writer.print(strValue);
            return this;
        }

        @Override
        public DotWriterOutput appendEscaped(String strValue) {
            this.writer.print(Output.escapeString(strValue));
            return this;
        }

        @Override
        public DotWriterOutput append(int intValue) {
            this.writer.print(intValue);
            return this;
        }

        @Override
        public DotWriterOutput newLine() {
            this.writer.println();
            return this;
        }

        private void close() {
            this.writer.close();
        }
    }
}

