/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.log;

import org.apache.commons.logging.Log;

class SimpleLog
implements Log {
    protected static final int LEVEL_NONE = 0;
    protected static final int LEVEL_FATAL = 1;
    protected static final int LEVEL_ERROR = 2;
    protected static final int LEVEL_WARN = 3;
    protected static final int LEVEL_INFO = 4;
    protected static final int LEVEL_DEBUG = 5;
    protected static final int LEVEL_TRACE = 6;
    protected static final int LEVEL_ALL = 7;
    protected static final String[] LEVEL_NAMES = new String[]{"NONE", "FATAL", "ERROR", "WARN", "INFO", "DEBUG", "TRACE", "ALL"};
    private static final int LOG_LEVEL = 3;

    SimpleLog() {
    }

    @Override
    public void debug(Object message) {
        this.log(message, 5);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(message, t, 5);
    }

    @Override
    public void error(Object message) {
        this.log(message, 2);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(message, t, 2);
    }

    @Override
    public void fatal(Object message) {
        this.log(message, 1);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(message, t, 1);
    }

    @Override
    public void info(Object message) {
        this.log(message, 4);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(message, t, 4);
    }

    @Override
    public boolean isDebugEnabled() {
        return false;
    }

    @Override
    public boolean isErrorEnabled() {
        return true;
    }

    @Override
    public boolean isFatalEnabled() {
        return true;
    }

    @Override
    public boolean isInfoEnabled() {
        return false;
    }

    @Override
    public boolean isTraceEnabled() {
        return false;
    }

    @Override
    public boolean isWarnEnabled() {
        return true;
    }

    @Override
    public void trace(Object message) {
        this.log(message, 6);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(message, t, 6);
    }

    @Override
    public void warn(Object message) {
        this.log(message, 3);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(message, t, 3);
    }

    protected void log(Object message, int level) {
        this.log(message, null, level);
    }

    protected void log(Object message, Throwable t, int level) {
        if (level <= 3) {
            System.out.println("[" + LEVEL_NAMES[level] + "] " + message);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }
}

