/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.log;

import net.ggtools.grand.log.AntLog;
import net.ggtools.grand.log.LoggerFactory;
import org.apache.commons.logging.Log;

public final class LoggerManager {
    private static LoggerFactory currentFactory;
    private static final LoggerFactory DEFAULT_FACTORY;

    public static Log getLog(Class<?> clazz) {
        if (currentFactory != null) {
            return currentFactory.getLog(clazz);
        }
        return DEFAULT_FACTORY.getLog(clazz);
    }

    public static Log getLog(String name) {
        if (currentFactory != null) {
            return currentFactory.getLog(name);
        }
        return DEFAULT_FACTORY.getLog(name);
    }

    public static void setFactory(LoggerFactory factory) {
        currentFactory = factory;
    }

    private LoggerManager() {
    }

    static {
        DEFAULT_FACTORY = new LoggerFactory(){

            @Override
            public Log getLog(Class<?> clazz) {
                return new AntLog();
            }

            @Override
            public Log getLog(String name) {
                return new AntLog();
            }
        };
    }
}

