/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.graph;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ggtools.grand.exceptions.DuplicateElementException;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.graph.SubGraph;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;

class SubGraphImpl
implements SubGraph {
    private static final Log LOG = LoggerManager.getLog(SubGraphImpl.class);
    private final String name;
    private final NodeIteratorFactory nodeIteratorFactory;
    private final Map<String, Node> nodeList = new LinkedHashMap<String, Node>();

    SubGraphImpl(String name) {
        this(name, new NodeIteratorFactory(){

            @Override
            public final Iterator<Node> createNodeIterator(Iterator<Node> iterator) {
                return iterator;
            }
        });
    }

    SubGraphImpl(String name, NodeIteratorFactory nodeIteratorFactory) {
        this.name = name;
        this.nodeIteratorFactory = nodeIteratorFactory;
    }

    @Override
    public void addNode(Node node) throws DuplicateElementException {
        String nodeName = node.getName();
        if (this.nodeList.containsKey(nodeName)) {
            LOG.error("addNode() - Cannot add two nodes with the same name : nodeName = " + nodeName, null);
            throw new DuplicateElementException("Creating two nodes named " + nodeName);
        }
        this.nodeList.put(nodeName, node);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Node getNode(String nodeName) {
        return this.nodeList.get(nodeName);
    }

    @Override
    public Iterator<Node> getNodes() {
        return this.nodeIteratorFactory.createNodeIterator(this.nodeList.values().iterator());
    }

    @Override
    public boolean hasNode(String nodeName) {
        return this.nodeList.containsKey(nodeName);
    }

    static interface NodeIteratorFactory {
        public Iterator<Node> createNodeIterator(Iterator<Node> var1);
    }
}

