/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.graph;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.ggtools.grand.graph.AttributeManager;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.Link;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.graph.visit.NodeVisitor;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;

public class NodeImpl
extends AttributeManager
implements Node {
    private static final Log LOG = LoggerManager.getLog(NodeImpl.class);
    private final String name;
    private final Graph graph;
    private String description;
    private final Set<Link> links;
    private final Set<Link> backLinks;
    private String source;

    public NodeImpl(String name, Graph graph) {
        this.name = name;
        this.graph = graph;
        this.links = new LinkedHashSet<Link>();
        this.backLinks = new LinkedHashSet<Link>();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Node) {
            Node otherNode = (Node)obj;
            return this.graph == otherNode.getGraph() && this.name.equals(otherNode.getName());
        }
        return false;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final String toString() {
        return this.name;
    }

    @Override
    public final Collection<Link> getLinks() {
        return this.links;
    }

    @Override
    public final Collection<Link> getBackLinks() {
        return this.backLinks;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public final Graph getGraph() {
        return this.graph;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void addLink(Link link) {
        this.links.add(link);
    }

    @Override
    public final void addBackLink(Link link) {
        this.backLinks.add(link);
    }

    @Override
    public final void removeLink(Link link) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.name + ": removing link " + link);
        }
        this.links.remove(link);
    }

    @Override
    public final void removeBackLink(Link link) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this.name + ": removing back link " + link);
        }
        this.backLinks.remove(link);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visitNode(this);
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    public final void setSource(String newSource) {
        this.source = newSource;
    }
}

