/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.graph;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ggtools.grand.exceptions.DuplicateElementException;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphElementFactory;
import net.ggtools.grand.graph.Link;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.graph.SimpleGraphElementFactory;
import net.ggtools.grand.graph.SubGraph;
import net.ggtools.grand.graph.SubGraphImpl;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;

public class GraphImpl
implements Graph {
    private static final Log LOG = LoggerManager.getLog(GraphImpl.class);
    private GraphElementFactory elementFactory;
    private Node graphStartNode;
    private final SubGraph mainSubGraph;
    private final String name;
    private final Map<String, SubGraph> subGraphList = new LinkedHashMap<String, SubGraph>();

    public GraphImpl(String graphName) {
        this.name = graphName;
        this.mainSubGraph = new SubGraphImpl(graphName, new SubGraphImpl.NodeIteratorFactory(){

            @Override
            public final Iterator<Node> createNodeIterator(Iterator<Node> iterator) {
                return new NodeIterator(iterator);
            }
        });
    }

    @Override
    public final Link createLink(String linkName, Node startNode, Node endNode) {
        Link link = this.getFactory().createLink(linkName, startNode, endNode);
        startNode.addLink(link);
        endNode.addBackLink(link);
        return link;
    }

    @Override
    public final Node createNode(String nodeName) throws DuplicateElementException {
        return this.createNode(this.mainSubGraph, nodeName);
    }

    @Override
    public final Node createNode(SubGraph subGraph, String nodeName) throws DuplicateElementException {
        if (subGraph.hasNode(nodeName)) {
            throw new DuplicateElementException("Creating two nodes named " + nodeName);
        }
        Node node = this.getFactory().createNode(nodeName);
        subGraph.addNode(node);
        return node;
    }

    @Override
    public final SubGraph createSubGraph(String subGraphName) throws DuplicateElementException {
        if (this.subGraphList.containsKey(subGraphName)) {
            LOG.error("createSubGraph(subGraphName = " + subGraphName + ") - Cannot create two subgraphs with the same name", null);
            throw new DuplicateElementException("A subgraph called " + subGraphName + " already exists");
        }
        SubGraphImpl newSubGraph = new SubGraphImpl(subGraphName);
        this.subGraphList.put(subGraphName, newSubGraph);
        return newSubGraph;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final Node getNode(String nodeName) {
        return this.mainSubGraph.getNode(nodeName);
    }

    @Override
    public final Iterator<Node> getNodes() {
        return this.mainSubGraph.getNodes();
    }

    @Override
    public final Node getStartNode() {
        return this.graphStartNode;
    }

    @Override
    public final SubGraph getSubGraph(String subGraphName) {
        return this.subGraphList.get(subGraphName);
    }

    @Override
    public final Iterator<SubGraph> getSubgraphs() {
        return this.subGraphList.values().iterator();
    }

    @Override
    public final boolean hasNode(String nodeName) {
        return this.mainSubGraph.hasNode(nodeName);
    }

    @Override
    public final boolean hasSubGraph(String subGraphName) {
        return this.subGraphList.containsKey(subGraphName);
    }

    @Override
    public final void setStartNode(Node node) {
        if (this.graphStartNode != null) {
            this.graphStartNode.clearAttributes(8);
        }
        this.graphStartNode = node;
        if (this.graphStartNode != null) {
            this.graphStartNode.setAttributes(8);
        }
    }

    protected GraphElementFactory getFactory() {
        if (this.elementFactory == null) {
            this.elementFactory = new SimpleGraphElementFactory(this);
        }
        return this.elementFactory;
    }

    protected final void unlinkNode(Node node) {
        Link link;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Unlinking node " + node);
        }
        Iterator<Link> iter = node.getLinks().iterator();
        while (iter.hasNext()) {
            link = iter.next();
            iter.remove();
            Node endNode = link.getEndNode();
            endNode.removeBackLink(link);
        }
        iter = node.getBackLinks().iterator();
        while (iter.hasNext()) {
            link = iter.next();
            iter.remove();
            Node startNode = link.getStartNode();
            startNode.removeLink(link);
        }
        if (node == this.graphStartNode) {
            this.graphStartNode = null;
        }
    }

    private class NodeIterator
    implements Iterator<Node> {
        private Node lastNode;
        private final Log log = LoggerManager.getLog(NodeIterator.class);
        private final Iterator<Node> underlying;

        public NodeIterator(Iterator<Node> iterator) {
            this.underlying = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        @Override
        public Node next() {
            this.lastNode = this.underlying.next();
            return this.lastNode;
        }

        @Override
        public void remove() {
            this.underlying.remove();
            GraphImpl.this.unlinkNode(this.lastNode);
        }
    }
}

