/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.graph;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.LinkFinder;
import net.ggtools.grand.graph.Node;

public class GraphCrawler {
    private final Graph graph;
    private final LinkFinder finder;

    public GraphCrawler(Graph graph, LinkFinder finder) {
        this.graph = graph;
        this.finder = finder;
    }

    public final Collection<Node> crawl(Node startNode) {
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        LinkedList<Node> nodesToVisit = new LinkedList<Node>();
        nodesToVisit.add(startNode);
        while (!nodesToVisit.isEmpty()) {
            Node current = (Node)nodesToVisit.removeFirst();
            if (result.contains(current)) continue;
            result.add(current);
            nodesToVisit.addAll(this.finder.getLinks(current));
        }
        return result;
    }
}

