/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.filters;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.filters.AbstractGraphFilter;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;

public class NodeRemoverFilter
extends AbstractGraphFilter {
    private static final Log LOG = LoggerManager.getLog(NodeRemoverFilter.class);
    private final Set<String> nodesToRemove;

    public NodeRemoverFilter(Collection<String> nodesToRemove) {
        super("Node remover");
        this.nodesToRemove = new HashSet<String>(nodesToRemove);
    }

    @Override
    protected final Collection<Node> getFilteredNodes() throws GrandException {
        Graph graph = this.getProducersGraph();
        LinkedHashSet<Node> result = new LinkedHashSet<Node>();
        Iterator<Node> iter = graph.getNodes();
        while (iter.hasNext()) {
            Node node = iter.next();
            if (this.nodesToRemove.contains(node.getName())) continue;
            result.add(node);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("getFilteredNodes() - end - return value = " + result);
        }
        return result;
    }
}

