/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.filters;

import java.util.Collection;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.exceptions.NonExistentNodeException;
import net.ggtools.grand.filters.AbstractGraphFilter;
import net.ggtools.grand.filters.GraphFilter;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphCrawler;
import net.ggtools.grand.graph.LinkFinder;
import net.ggtools.grand.graph.Node;

public abstract class GraphWalkFilter
extends AbstractGraphFilter
implements GraphFilter {
    private final String startNodeName;

    protected GraphWalkFilter(String nodeName) {
        this.startNodeName = nodeName;
    }

    @Override
    protected final Collection<Node> getFilteredNodes() throws GrandException {
        Graph graph = this.getProducersGraph();
        Node fromNode = graph.getNode(this.startNodeName);
        if (fromNode == null) {
            throw new NonExistentNodeException("Node " + this.startNodeName + " does not exist");
        }
        GraphCrawler crawler = new GraphCrawler(graph, this.getLinkFinder());
        return crawler.crawl(fromNode);
    }

    public abstract LinkFinder getLinkFinder();
}

