/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.filters;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.filters.GraphFilter;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphProducer;

public class FilterChain
implements GraphFilter {
    private final LinkedList<GraphFilter> filterList = new LinkedList();
    private GraphProducer lastFilter = null;
    private final String name;
    private GraphProducer producer = null;

    public FilterChain() {
        this("Anonymous");
    }

    public FilterChain(String name) {
        this.name = name;
    }

    public final void addFilterFirst(GraphFilter newFilter) {
        if (this.filterList.isEmpty()) {
            this.lastFilter = newFilter;
        } else {
            GraphFilter oldFirstFilter = this.filterList.getFirst();
            oldFirstFilter.setProducer(newFilter);
        }
        this.filterList.addFirst(newFilter);
        if (this.producer != null) {
            newFilter.setProducer(this.producer);
        }
    }

    public final void addFilterLast(GraphFilter newFilter) {
        this.filterList.addLast(newFilter);
        newFilter.setProducer(this.lastFilter);
        this.lastFilter = newFilter;
    }

    public final void clearFilters() {
        this.filterList.clear();
        this.lastFilter = this.producer;
    }

    public final List<GraphFilter> getFilterList() {
        return Collections.unmodifiableList(this.filterList);
    }

    @Override
    public final Graph getGraph() throws GrandException {
        Graph filteredGraph = this.lastFilter == null ? null : this.lastFilter.getGraph();
        return filteredGraph;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setProducer(GraphProducer newProducer) {
        this.producer = newProducer;
        if (this.filterList.isEmpty()) {
            this.lastFilter = newProducer;
        } else {
            GraphFilter firstFilter = this.filterList.getFirst();
            firstFilter.setProducer(this.producer);
        }
    }
}

