/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.filters;

import java.util.Collection;
import java.util.Iterator;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.filters.GraphFilter;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphProducer;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;

public abstract class AbstractGraphFilter
implements GraphFilter {
    private static final Log LOG = LoggerManager.getLog(AbstractGraphFilter.class);
    private GraphProducer graphProducer;
    private Graph producersGraph;
    protected final String name;

    protected AbstractGraphFilter() {
        this("Anonymous");
    }

    protected AbstractGraphFilter(String name) {
        this.name = name;
    }

    @Override
    public final Graph getGraph() throws GrandException {
        LOG.debug("Triggering AbstractGraphFilter");
        Graph graph = this.getProducersGraph();
        if (graph != null) {
            Collection<Node> nodeList = this.getFilteredNodes();
            Iterator<Node> iter = graph.getNodes();
            while (iter.hasNext()) {
                Node node = iter.next();
                if (nodeList.contains(node)) continue;
                iter.remove();
            }
        }
        this.producersGraph = null;
        return graph;
    }

    @Override
    public final void setProducer(GraphProducer producer) {
        this.graphProducer = producer;
        this.producersGraph = null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected abstract Collection<Node> getFilteredNodes() throws GrandException;

    protected final GraphProducer getGraphProducer() {
        return this.graphProducer;
    }

    protected final Graph getProducersGraph() throws GrandException {
        if (this.producersGraph == null && this.graphProducer != null) {
            this.producersGraph = this.graphProducer.getGraph();
        }
        return this.producersGraph;
    }
}

