/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.ant;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ggtools.grand.ant.AntProject;
import net.ggtools.grand.ant.AntTargetNode;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

class TargetTasksExplorer {
    private static final Log LOG = LoggerManager.getLog(TargetTasksExplorer.class);
    private List<AntTargetNode.SourceElement> textElements;

    TargetTasksExplorer(AntProject antProject) {
    }

    public void exploreTarget(AntTargetNode node, Target target) {
        Task[] taskArray;
        boolean hasChildren;
        Enumeration dependencies;
        LOG.trace("Exploring target " + target.getName());
        this.textElements = new LinkedList<AntTargetNode.SourceElement>();
        this.addText("<target name=\"", 1);
        this.addText(target.getName(), 2);
        this.addText("\"", 1);
        if (node.getIfCondition() != null) {
            this.addText(" if=\"", 1);
            this.addText(node.getIfCondition(), 2);
            this.addText("\"", 1);
        }
        if (node.getUnlessCondition() != null) {
            this.addText(" unless=\"", 1);
            this.addText(node.getUnlessCondition(), 2);
            this.addText("\"", 1);
        }
        if ((dependencies = target.getDependencies()).hasMoreElements()) {
            this.addText(" depends=\"", 1);
            while (dependencies.hasMoreElements()) {
                String dependency = (String)dependencies.nextElement();
                this.addText(dependency, 2);
                if (!dependencies.hasMoreElements()) continue;
                this.addText(", ", 2);
            }
            this.addText("\"", 1);
        }
        if (target.getDescription() != null) {
            this.addText(" description=\"", 1);
            this.addText(target.getDescription(), 2);
            this.addText("\"", 1);
        }
        boolean bl = hasChildren = (taskArray = target.getTasks()).length > 0;
        if (hasChildren) {
            this.addText(">\n", 1);
        } else {
            this.addText(" />\n", 1);
        }
        for (Task task : taskArray) {
            this.exploreTask(task.getRuntimeConfigurableWrapper(), 1);
        }
        if (hasChildren) {
            this.addText("</target>", 1);
        }
        AntTargetNode.SourceElement previous = null;
        Iterator<AntTargetNode.SourceElement> iter = this.textElements.iterator();
        while (iter.hasNext()) {
            AntTargetNode.SourceElement element = iter.next();
            if (previous == null) {
                previous = element;
                continue;
            }
            if (previous.getStyle() == element.getStyle()) {
                previous.setText(previous.getText().concat(element.getText()));
                iter.remove();
                continue;
            }
            previous = element;
        }
        node.setRichSource(this.textElements.toArray(new AntTargetNode.SourceElement[0]));
        StringBuilder buffer = new StringBuilder();
        for (AntTargetNode.SourceElement element : this.textElements) {
            buffer.append(element.getText());
        }
        node.setSource(buffer.toString());
    }

    private void exploreTask(RuntimeConfigurable wrapper, int level) {
        boolean hasNestedElements;
        this.indent(level);
        this.addText("<", 1);
        this.addText(wrapper.getElementTag(), 1);
        Hashtable attributes = wrapper.getAttributeMap();
        for (Map.Entry entry : attributes.entrySet()) {
            this.addText(" ", 1);
            this.addText((String)entry.getKey(), 1);
            this.addText("=\"", 1);
            this.addText((String)entry.getValue(), 2);
            this.addText("\"", 1);
        }
        Enumeration children = wrapper.getChildren();
        String trimmedText = wrapper.getText().toString().trim();
        boolean hasText = !"".equals(trimmedText);
        boolean hasChildren = children.hasMoreElements();
        boolean bl = hasNestedElements = hasChildren || hasText;
        if (hasNestedElements) {
            this.addText(">", 1);
            if (hasChildren) {
                this.addText("\n", 1);
            }
        } else {
            this.addText(" />\n", 1);
        }
        while (children.hasMoreElements()) {
            RuntimeConfigurable childWrapper = (RuntimeConfigurable)children.nextElement();
            this.exploreTask(childWrapper, level + 1);
        }
        if (hasText) {
            this.addText(trimmedText, 3);
        }
        if (hasNestedElements) {
            if (!hasText) {
                this.indent(level);
            }
            this.addText("</", 1);
            this.addText(wrapper.getElementTag(), 1);
            this.addText(">\n", 1);
        }
    }

    private void addText(String text, int style) {
        this.textElements.add(new AntTargetNode.SourceElement(text, style));
    }

    private void indent(int level) {
        StringBuilder buffer = new StringBuilder(level * 4);
        for (int i = 0; i < level; ++i) {
            buffer.append("   ");
        }
        this.addText(buffer.toString(), 3);
    }
}

