/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.ant;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.ggtools.grand.ant.TaskVisitor;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.RuntimeConfigurable;

abstract class ReflectTaskVisitorBase
implements TaskVisitor {
    private static final Log LOG = LoggerManager.getLog(ReflectTaskVisitorBase.class);
    private static final Class<?>[] METHOD_PARAMETER_TYPES = new Class[]{RuntimeConfigurable.class};
    private final Map<String, Method> methodCache = new HashMap<String, Method>();

    ReflectTaskVisitorBase() {
    }

    @Override
    public void visit(RuntimeConfigurable wrapper) throws GrandException {
        String taskName = wrapper.getElementTag();
        Method visitMethod = this.methodCache.get(taskName);
        if (visitMethod == null) {
            String methodName = "reflectVisit_" + this.getAliasForTask(taskName);
            try {
                visitMethod = this.getClass().getDeclaredMethod(methodName, METHOD_PARAMETER_TYPES);
                this.methodCache.put(taskName, visitMethod);
            }
            catch (SecurityException e) {
                LOG.warn("Caught Security exception looking for" + methodName, e);
            }
            catch (NoSuchMethodException e) {
                LOG.debug("Cannot find method " + methodName);
            }
        }
        boolean invocationOk = false;
        if (visitMethod != null) {
            try {
                visitMethod.invoke((Object)this, wrapper);
                invocationOk = true;
            }
            catch (IllegalAccessException e) {
                LOG.warn("Caught IllegalAccessException invoking " + visitMethod, e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof GrandException) {
                    throw (GrandException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                LOG.error("Caught unexpected exception " + cause + " on " + visitMethod, e);
            }
        }
        if (!invocationOk) {
            this.defaultVisit(wrapper);
        }
    }

    public abstract void defaultVisit(RuntimeConfigurable var1) throws GrandException;

    public String getAliasForTask(String taskName) {
        return taskName;
    }
}

