/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.ggtools.grand.ant.AntGraph;
import net.ggtools.grand.ant.AntProject;
import net.ggtools.grand.ant.AntTargetNode;
import net.ggtools.grand.ant.AntTaskLink;
import net.ggtools.grand.ant.ReflectTaskVisitorBase;
import net.ggtools.grand.ant.SubantTaskLink;
import net.ggtools.grand.ant.taskhelpers.SubAntHelper;
import net.ggtools.grand.exceptions.DuplicateElementException;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.types.Path;

public class LinkFinderVisitor
extends ReflectTaskVisitorBase {
    private static final Log LOG = LoggerManager.getLog(LinkFinderVisitor.class);
    private static final Map<String, String> ALIASES = new HashMap<String, String>();
    private static final String ANT_FILE_PROPERTY = "ant.file";
    private static final String ATTR_ANTFILE = "antfile";
    private static final String ATTR_DIR = "dir";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TARGET = "target";
    private static final String ATTR_VALUE = "value";
    private static final String BUILD_XML = "build.xml";
    private static final String PARAM_ELEMENT = "param";
    private static final String PROPERTY_ELEMENT = "property";
    private AntGraph graph;
    private final AntProject project;
    private AntTargetNode startNode;

    public LinkFinderVisitor(AntProject project) {
        this.project = project;
    }

    @Override
    public final void defaultVisit(RuntimeConfigurable wrapper) throws GrandException {
        Enumeration children = wrapper.getChildren();
        while (children.hasMoreElements()) {
            this.visit((RuntimeConfigurable)children.nextElement());
        }
    }

    @Override
    public final String getAliasForTask(String taskName) {
        String result = ALIASES.get(taskName);
        if (result == null) {
            result = taskName;
        }
        return result;
    }

    public final void reflectVisit_ant(RuntimeConfigurable wrapper) throws DuplicateElementException {
        AntTaskLink[] links;
        List<Object> targetElements;
        Project antProject = this.project.getAntProject();
        LOG.info("Processing ant target in " + this.startNode.getName());
        String targetBuildDirectoryName = (String)wrapper.getAttributeMap().get(ATTR_DIR);
        String antFile = (String)wrapper.getAttributeMap().get(ATTR_ANTFILE);
        antFile = antFile == null ? BUILD_XML : antProject.replaceProperties(antFile);
        File targetBuildFile = new File(antFile);
        if (!targetBuildFile.isAbsolute()) {
            if (targetBuildDirectoryName == null) {
                targetBuildFile = new File(antProject.getBaseDir(), antFile);
            } else {
                String parentDirectoryName = antProject.replaceProperties(targetBuildDirectoryName);
                File parentDirectory = new File(parentDirectoryName);
                if (!parentDirectory.isAbsolute()) {
                    parentDirectory = new File(antProject.getBaseDir(), parentDirectoryName);
                }
                targetBuildFile = new File(parentDirectory, antFile);
            }
        }
        if ((targetElements = this.getTargetElementNames(wrapper)).size() > 0) {
            links = new AntTaskLink[targetElements.size()];
            int i = 0;
            for (Object object : targetElements) {
                links[i++] = this.createAntTaskLink(targetBuildFile, wrapper.getElementTag(), (String)object);
            }
        } else {
            links = new AntTaskLink[]{this.createAntTaskLink(targetBuildFile, wrapper.getElementTag(), (String)wrapper.getAttributeMap().get(ATTR_TARGET))};
        }
        this.addNestPropertiesParameters(wrapper, links, PROPERTY_ELEMENT);
    }

    private List<Object> getTargetElementNames(RuntimeConfigurable wrapper) {
        ArrayList<Object> targetElements = new ArrayList<Object>();
        Enumeration children = wrapper.getChildren();
        while (children.hasMoreElements()) {
            Hashtable childAttributeMap;
            Object name;
            RuntimeConfigurable child = (RuntimeConfigurable)children.nextElement();
            if (!ATTR_TARGET.equals(child.getElementTag()) || (name = (childAttributeMap = child.getAttributeMap()).get(ATTR_NAME)) == null) continue;
            targetElements.add(name);
        }
        return targetElements;
    }

    public final void reflectVisit_antcall(RuntimeConfigurable wrapper) throws DuplicateElementException {
        AntTaskLink[] links;
        LOG.info("Processing antcall target in " + this.startNode.getName());
        Project antProject = this.project.getAntProject();
        List<Object> targetElements = this.getTargetElementNames(wrapper);
        String elementTag = wrapper.getElementTag();
        if (targetElements.size() > 0) {
            links = new AntTaskLink[targetElements.size()];
            int i = 0;
            for (Object object : targetElements) {
                String endNodeName = antProject.replaceProperties((String)object);
                AntTargetNode endNode = this.findOrCreateNode(endNodeName);
                LOG.debug("Creating link from " + this.startNode + " to " + endNodeName);
                links[i++] = this.graph.createTaskLink(null, this.startNode, endNode, elementTag);
            }
        } else {
            String endNodeName = antProject.replaceProperties((String)wrapper.getAttributeMap().get(ATTR_TARGET));
            AntTargetNode endNode = this.findOrCreateNode(endNodeName);
            LOG.debug("Creating link from " + this.startNode + " to " + endNodeName);
            links = new AntTaskLink[]{this.graph.createTaskLink(null, this.startNode, endNode, elementTag)};
        }
        this.addNestPropertiesParameters(wrapper, links, PARAM_ELEMENT);
    }

    public final void reflectVisit_subant(RuntimeConfigurable wrapper) throws DuplicateElementException {
        LOG.info("Processing subant target in " + this.startNode.getName());
        Project antProject = this.project.getAntProject();
        ((Task)wrapper.getProxy()).maybeConfigure();
        Object proxy = wrapper.getProxy();
        if (proxy instanceof SubAntHelper) {
            String[] filenames;
            SubAntHelper helper = (SubAntHelper)((Object)proxy);
            Path buildPath = helper.getBuildpath();
            String antfile = helper.getAntfile();
            File genericantfile = helper.getGenericAntfile();
            List<Property> properties = helper.getProperties();
            String target = helper.getTarget();
            LinkedList<File> genericantfileDirs = new LinkedList<File>();
            if (buildPath == null || buildPath.size() == 0) {
                LOG.warn("buildPath is null or empty, subant task probably won't work");
                return;
            }
            for (String currentFileName : filenames = buildPath.list()) {
                File directory = null;
                File file = new File(currentFileName);
                if (file.isDirectory()) {
                    if (genericantfile != null) {
                        directory = file;
                        file = genericantfile;
                    } else {
                        file = new File(file, antfile);
                    }
                }
                if (directory == null) {
                    AntTaskLink link = this.createAntTaskLink(file, wrapper.getElementTag(), target);
                    for (Property property : properties) {
                        if (property.getName() != null) {
                            link.setParameter(property.getName(), antProject.replaceProperties(property.getValue()));
                            continue;
                        }
                        if (property.getFile() == null) continue;
                        File propFile = property.getFile();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Loading " + propFile.getAbsolutePath());
                        }
                        link.addPropertyFile(propFile.getAbsolutePath());
                    }
                    continue;
                }
                genericantfileDirs.add(directory);
            }
            if (genericantfileDirs.size() > 0) {
                AntTargetNode endNode = this.findOrCreateNode(target, genericantfile);
                LOG.debug("Creating link from " + this.startNode + " to " + endNode.getName());
                SubantTaskLink link = this.graph.createSubantTaskLink(null, this.startNode, endNode, wrapper.getElementTag());
                for (File currentDir : genericantfileDirs) {
                    link.addDirectory(currentDir.getAbsolutePath());
                }
            }
        } else {
            LOG.warn("Cannot get information for subant task");
            LOG.debug("Task should be instance of SubAntHelper but is " + proxy);
        }
    }

    public final void setGraph(AntGraph graph) {
        this.graph = graph;
    }

    public final void setStartNode(AntTargetNode startNode) {
        this.startNode = startNode;
    }

    private void addNestPropertiesParameters(RuntimeConfigurable wrapper, AntTaskLink[] links, String elementName) {
        Project antProject = this.project.getAntProject();
        Enumeration children = wrapper.getChildren();
        while (children.hasMoreElements()) {
            RuntimeConfigurable child = (RuntimeConfigurable)children.nextElement();
            if (!elementName.equals(child.getElementTag())) continue;
            Hashtable childAttributeMap = child.getAttributeMap();
            String name = (String)childAttributeMap.get(ATTR_NAME);
            if (name != null) {
                String propertyValue = antProject.replaceProperties((String)childAttributeMap.get(ATTR_VALUE));
                for (AntTaskLink link : links) {
                    link.setParameter(name, propertyValue);
                }
                continue;
            }
            String fileName = (String)childAttributeMap.get("file");
            if (fileName == null) continue;
            for (AntTaskLink link : links) {
                link.addPropertyFile(antProject.replaceProperties(fileName));
            }
        }
    }

    private AntTaskLink createAntTaskLink(File targetBuildFile, String taskName, String target) throws DuplicateElementException {
        AntTargetNode endNode = this.findOrCreateNode(target, targetBuildFile);
        LOG.debug("Creating link from " + this.startNode + " to " + endNode.getName());
        return this.graph.createTaskLink(null, this.startNode, endNode, taskName);
    }

    private AntTargetNode findOrCreateNode(String endNodeName) throws DuplicateElementException {
        return this.findOrCreateNode(endNodeName, null);
    }

    private AntTargetNode findOrCreateNode(String target, File targetBuildFile) throws DuplicateElementException {
        AntTargetNode endNode;
        String endNodeName;
        Project antProject = this.project.getAntProject();
        File projectFile = new File(antProject.getProperty(ANT_FILE_PROPERTY));
        if (targetBuildFile == null) {
            targetBuildFile = projectFile;
        }
        boolean isSameBuildFile = projectFile.equals(targetBuildFile);
        String targetName = antProject.replaceProperties(target);
        if (isSameBuildFile) {
            endNodeName = targetName == null ? antProject.getDefaultTarget() : targetName;
            endNode = (AntTargetNode)this.graph.getNode(endNodeName);
        } else {
            if (targetName == null) {
                try {
                    LOG.debug("Reading project file " + targetBuildFile);
                    AntProject tmpProj = new AntProject(targetBuildFile);
                    targetName = tmpProj.getAntProject().getDefaultTarget();
                }
                catch (GrandException e) {
                    LOG.info("Caught exception trying to read " + targetBuildFile + " using default target name", e);
                    targetName = "'default'";
                }
            }
            int index = 1;
            boolean conflict = false;
            endNodeName = "[" + targetName + "]";
            do {
                conflict = false;
                endNode = (AntTargetNode)this.graph.getNode(endNodeName);
                if (endNode == null || targetBuildFile.getAbsolutePath().equals(endNode.getBuildFile())) continue;
                LOG.error("Conflict on build file " + targetBuildFile + " vs " + endNode.getBuildFile());
                conflict = true;
                endNodeName = "[" + targetName + " (" + ++index + ")]";
            } while (conflict);
        }
        if (endNode == null) {
            LOG.info("Target " + this.startNode + " has dependency to non existent target " + endNodeName + ", creating a dummy node");
            endNode = (AntTargetNode)this.graph.createNode(endNodeName);
            endNode.setAttributes(2);
        }
        if (!isSameBuildFile) {
            endNode.setBuildFile(targetBuildFile.getAbsolutePath());
        }
        return endNode;
    }

    static {
        ALIASES.put("runtarget", "antcall");
        ALIASES.put("foreach", "antcall");
        ALIASES.put("antcallback", "antcall");
        ALIASES.put("antfetch", "ant");
        ALIASES.put("switch", "if");
        ALIASES.put("trycatch", "if");
    }
}

