/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand.ant;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.ggtools.grand.ant.AntGraph;
import net.ggtools.grand.ant.AntLink;
import net.ggtools.grand.ant.AntTargetNode;
import net.ggtools.grand.ant.LinkFinderVisitor;
import net.ggtools.grand.ant.TargetTasksExplorer;
import net.ggtools.grand.ant.taskhelpers.SubAntHelper;
import net.ggtools.grand.ant.taskhelpers.TaskDefHelper;
import net.ggtools.grand.exceptions.DuplicateElementException;
import net.ggtools.grand.exceptions.GrandException;
import net.ggtools.grand.graph.Graph;
import net.ggtools.grand.graph.GraphProducer;
import net.ggtools.grand.graph.Node;
import net.ggtools.grand.log.LoggerManager;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;

public class AntProject
implements GraphProducer {
    private static final Log LOG = LoggerManager.getLog(AntProject.class);
    private final Project antProject;
    private final TargetConditionHelper targetConditionHelper = TargetConditionHelperFactory.getTargetConditionHelper();
    private final TargetTasksExplorer targetExplorer = new TargetTasksExplorer(this);
    private LinkFinderVisitor taskLinkFinder;

    public AntProject(File source) throws GrandException {
        this(source, null);
    }

    public AntProject(File source, Properties properties) throws GrandException {
        LOG.info("Parsing from " + source);
        this.antProject = new Project();
        if (properties != null) {
            for (Map.Entry<Object, Object> element : properties.entrySet()) {
                this.antProject.setProperty((String)element.getKey(), (String)element.getValue());
            }
        }
        this.antProject.setSystemProperties();
        this.antProject.init();
        this.antProject.setUserProperty("ant.file", source.getAbsolutePath());
        this.postInit();
        try {
            ProjectHelper loader = ProjectHelper.getProjectHelper();
            this.antProject.addReference("ant.projectHelper", (Object)loader);
            loader.parse(this.antProject, (Object)source);
            LOG.debug("Done parsing");
        }
        catch (BuildException e) {
            String message = "Cannot open project file " + source;
            LOG.error(message, e);
            throw new GrandException(message, e);
        }
    }

    private void postInit() {
        this.taskLinkFinder = new LinkFinderVisitor(this);
        ComponentHelper helper = (ComponentHelper)this.antProject.getReference("ant.ComponentHelper");
        if (helper != null) {
            AntTypeDefinition subAntDef = helper.getDefinition("subant");
            if (subAntDef == null) {
                LOG.warn("No definition found for the subant task in ComponentHelper, disabling subant");
            } else {
                subAntDef.setClass(SubAntHelper.class);
            }
            AntTypeDefinition taskDefDef = helper.getDefinition("taskdef");
            if (taskDefDef == null) {
                LOG.warn("No definition found for the taskdef task in ComponentHelper, some file may not load properly");
            } else {
                taskDefDef.setClass(TaskDefHelper.class);
            }
        } else {
            LOG.warn("No component helper in current project");
        }
    }

    public AntProject(Project project) {
        this.antProject = project;
        this.postInit();
    }

    public final Project getAntProject() {
        return this.antProject;
    }

    @Override
    public final Graph getGraph() throws GrandException {
        Node startNode;
        LOG.debug("Triggering AntProject");
        AntGraph graph = new AntGraph(this.antProject);
        HashMap<String, String> targetMap = new HashMap<String, String>();
        for (Target target : this.antProject.getTargets().values()) {
            String targetDescription;
            if (target.getName().equals("")) continue;
            String targetName = target.getName();
            AntTargetNode node = (AntTargetNode)graph.createNode(targetName);
            String location = target.getLocation().toString();
            if (!targetMap.containsKey(location) || ((String)targetMap.get(location)).length() > targetName.length()) {
                targetMap.put(location, targetName);
            }
            if ((targetDescription = target.getDescription()) != null && !targetDescription.equals("")) {
                node.setAttributes(1);
                node.setDescription(targetDescription);
            }
            node.setIfCondition(this.targetConditionHelper.getIfCondition(target));
            node.setUnlessCondition(this.targetConditionHelper.getUnlessCondition(target));
            this.targetExplorer.exploreTarget(node, target);
        }
        String defaultTarget = this.antProject.getDefaultTarget();
        if (defaultTarget != null && (startNode = graph.getNode(defaultTarget)) != null) {
            graph.setStartNode(startNode);
        }
        for (Target target : this.antProject.getTargets().values()) {
            Task[] tasks;
            if (target.getName().equals("")) continue;
            Enumeration deps = target.getDependencies();
            String startNodeName = target.getName();
            AntTargetNode startNode2 = (AntTargetNode)graph.getNode(startNodeName);
            if (!targetMap.containsValue(startNodeName)) {
                startNode2.setAttributes(16);
            }
            while (deps.hasMoreElements()) {
                this.createLink(graph, null, startNode2, (String)deps.nextElement());
            }
            this.taskLinkFinder.setGraph(graph);
            this.taskLinkFinder.setStartNode(startNode2);
            for (Task element : tasks = target.getTasks()) {
                this.taskLinkFinder.visit(element.getRuntimeConfigurableWrapper());
            }
        }
        return graph;
    }

    private AntLink createLink(Graph graph, String linkName, Node startNode, String endNodeName) throws DuplicateElementException {
        Node endNode = graph.getNode(endNodeName);
        if (endNode == null) {
            LOG.warn("Target " + startNode + " has dependency to non existent target " + endNodeName + ", creating a dummy node");
            endNode = graph.createNode(endNodeName);
            endNode.setAttributes(2);
        }
        LOG.debug("Creating link from " + startNode + " to " + endNodeName);
        return (AntLink)graph.createLink(linkName, startNode, endNode);
    }

    private static final class TargetConditionHelperFactory {
        public static TargetConditionHelper getTargetConditionHelper() {
            TargetConditionHelper result;
            try {
                result = new GetterConditionHelper();
                LOG.debug("Using Ant getter");
            }
            catch (Exception e) {
                LOG.debug("Cannot create GetterConditionHelper, trying next one");
                result = null;
            }
            if (result == null) {
                try {
                    result = new ReflectHelper();
                    LOG.debug("Using ReflectHelper");
                }
                catch (Exception e) {
                    LOG.debug("Cannot create ReflectHelper, trying next one");
                    result = null;
                }
            }
            if (result == null) {
                result = new NullConditionHelper();
            }
            return result;
        }

        private TargetConditionHelperFactory() {
        }
    }

    private static interface TargetConditionHelper {
        public String getIfCondition(Target var1);

        public String getUnlessCondition(Target var1);
    }

    private static class ReflectHelper
    implements TargetConditionHelper {
        private final Field ifCondition = Target.class.getDeclaredField("ifCondition");
        private final Field unlessCondition = Target.class.getDeclaredField("unlessCondition");

        public ReflectHelper() throws NoSuchFieldException {
            AccessibleObject.setAccessible(new AccessibleObject[]{this.ifCondition, this.unlessCondition}, true);
        }

        @Override
        public String getIfCondition(Target target) {
            String result = null;
            try {
                result = (String)this.ifCondition.get(target);
                if ("".equals(result)) {
                    result = null;
                }
            }
            catch (Exception e) {
                LOG.error("Caught exception, ignoring if condition", e);
            }
            return result;
        }

        @Override
        public String getUnlessCondition(Target target) {
            String result = null;
            try {
                result = (String)this.unlessCondition.get(target);
                if ("".equals(result)) {
                    result = null;
                }
            }
            catch (Exception e) {
                LOG.error("Caught exception, ignoring unless condition", e);
            }
            return result;
        }
    }

    private static class NullConditionHelper
    implements TargetConditionHelper {
        private NullConditionHelper() {
        }

        @Override
        public String getIfCondition(Target target) {
            return null;
        }

        @Override
        public String getUnlessCondition(Target target) {
            return null;
        }
    }

    private static class GetterConditionHelper
    implements TargetConditionHelper {
        public GetterConditionHelper() throws NoSuchMethodException {
            Class[] parameters = new Class[]{};
            Target.class.getMethod("getIf", parameters);
            Target.class.getMethod("getUnless", parameters);
        }

        @Override
        public String getIfCondition(Target target) {
            return target.getIf();
        }

        @Override
        public String getUnlessCondition(Target target) {
            return target.getUnless();
        }
    }
}

