/*
 * Decompiled with CFR 0.152.
 */
package net.ggtools.grand;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class Configuration {
    private static final String ANT_VERSION_TXT = "/org/apache/tools/ant/version.txt";
    private static Configuration defaultConfiguration;
    private static volatile Properties defaultProperties;
    private static final Object DEFAULT_PROPERTIES_MONITOR;
    private final String antVersionString;
    private final Properties buildProperties;
    private final Properties properties;
    private final String versionString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration() throws IOException {
        Class<Configuration> clazz = Configuration.class;
        synchronized (Configuration.class) {
            if (defaultConfiguration == null) {
                defaultConfiguration = Configuration.getConfiguration((Properties)null);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultConfiguration;
        }
    }

    public static Configuration getConfiguration(File propFile) throws IOException {
        Properties override = new Properties();
        override.load(new FileInputStream(propFile));
        return Configuration.getConfiguration(override);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getConfiguration(Properties override) throws IOException {
        Object object = DEFAULT_PROPERTIES_MONITOR;
        synchronized (object) {
            if (defaultProperties == null) {
                defaultProperties = new Properties();
                defaultProperties.load(Configuration.class.getResourceAsStream("Default.properties"));
            }
        }
        return new Configuration(override);
    }

    protected Configuration(Properties override) throws IOException {
        if (override != null) {
            this.properties = new Properties(defaultProperties);
            this.properties.putAll((Map<?, ?>)override);
        } else {
            this.properties = defaultProperties;
        }
        this.buildProperties = new Properties();
        this.buildProperties.load(this.getClass().getResourceAsStream("buildnum.properties"));
        this.versionString = "v" + this.buildProperties.getProperty("build.version.string") + " (build " + this.buildProperties.getProperty("build.number") + " " + this.buildProperties.getProperty("build.date") + ")";
        Properties antProperties = new Properties();
        InputStream antVersionStream = this.getClass().getResourceAsStream(ANT_VERSION_TXT);
        if (antVersionStream != null) {
            antProperties.load(antVersionStream);
            this.antVersionString = antProperties.getProperty("VERSION") + " (" + antProperties.getProperty("DATE", "Unknown") + ")";
        } else {
            this.antVersionString = null;
        }
    }

    public final String get(String key) {
        return this.properties.getProperty(key);
    }

    public final String getAntVersionString() {
        return this.antVersionString;
    }

    public final Properties getBuildProperties() {
        return this.buildProperties;
    }

    public final String getVersionString() {
        return this.versionString;
    }

    static {
        DEFAULT_PROPERTIES_MONITOR = new Object();
    }
}

