/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;

public final class MergedCellsTable
extends RecordAggregate {
    private static int MAX_MERGED_REGIONS = 1027;
    private final List<CellRangeAddress> _mergedRegions = new ArrayList<CellRangeAddress>();

    public void read(RecordStream recordStream) {
        List<CellRangeAddress> list = this._mergedRegions;
        while (recordStream.peekNextClass() == MergeCellsRecord.class) {
            MergeCellsRecord mergeCellsRecord = (MergeCellsRecord)recordStream.getNext();
            int n = mergeCellsRecord.getNumAreas();
            for (int i = 0; i < n; ++i) {
                CellRangeAddress cellRangeAddress = mergeCellsRecord.getAreaAt(i);
                list.add(cellRangeAddress);
            }
        }
    }

    @Override
    public int getRecordSize() {
        int n = this._mergedRegions.size();
        if (n < 1) {
            return 0;
        }
        int n2 = n / MAX_MERGED_REGIONS;
        int n3 = n % MAX_MERGED_REGIONS;
        int n4 = n2 * (4 + CellRangeAddressList.getEncodedSize(MAX_MERGED_REGIONS)) + 4 + CellRangeAddressList.getEncodedSize(n3);
        return n4;
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        int n;
        int n2 = this._mergedRegions.size();
        if (n2 < 1) {
            return;
        }
        int n3 = n2 / MAX_MERGED_REGIONS;
        int n4 = n2 % MAX_MERGED_REGIONS;
        CellRangeAddress[] cellRangeAddressArray = new CellRangeAddress[n2];
        this._mergedRegions.toArray(cellRangeAddressArray);
        for (n = 0; n < n3; ++n) {
            int n5 = n * MAX_MERGED_REGIONS;
            recordVisitor.visitRecord(new MergeCellsRecord(cellRangeAddressArray, n5, MAX_MERGED_REGIONS));
        }
        if (n4 > 0) {
            n = n3 * MAX_MERGED_REGIONS;
            recordVisitor.visitRecord(new MergeCellsRecord(cellRangeAddressArray, n, n4));
        }
    }

    public void addRecords(MergeCellsRecord[] mergeCellsRecordArray) {
        for (int i = 0; i < mergeCellsRecordArray.length; ++i) {
            this.addMergeCellsRecord(mergeCellsRecordArray[i]);
        }
    }

    private void addMergeCellsRecord(MergeCellsRecord mergeCellsRecord) {
        int n = mergeCellsRecord.getNumAreas();
        for (int i = 0; i < n; ++i) {
            CellRangeAddress cellRangeAddress = mergeCellsRecord.getAreaAt(i);
            this._mergedRegions.add(cellRangeAddress);
        }
    }
}

