/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.urbanisme;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.opendata.core.datasets.WayCombiner;
import org.openstreetmap.josm.plugins.opendata.modules.fr.paris.datasets.ParisDataSetHandler;
import org.openstreetmap.josm.tools.UserCancelException;

public class SanisettesHandler
extends ParisDataSetHandler {
    public SanisettesHandler() {
        super(93);
        this.setName("Sanisettes");
        this.getShpHandler().setCheckNodeProximity(true);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"sanisettes"}) || this.acceptsZipFilename(filename, new String[]{"sanisettes"});
    }

    private boolean wayBelongsTo(Way a, List<Way> ways) {
        for (Way b : ways) {
            if (!a.getNode(0).equals((Object)b.getNode(0)) && !a.getNode(0).equals((Object)b.getNode(b.getNodesCount() - 1)) && !a.getNode(a.getNodesCount() - 1).equals((Object)b.getNode(0)) && !a.getNode(a.getNodesCount() - 1).equals((Object)b.getNode(b.getNodesCount() - 1))) continue;
            return true;
        }
        return false;
    }

    private boolean wayProcessed(Way a, List<List<Way>> waysToCombine) {
        for (List<Way> ways : waysToCombine) {
            for (Way b : ways) {
                if (!a.equals((Object)b)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateDataSet(DataSet ds) {
        ArrayList sourceWays = new ArrayList(ds.getWays());
        ArrayList<List<Way>> waysToCombine = new ArrayList<List<Way>>();
        Iterator it = sourceWays.iterator();
        while (it.hasNext()) {
            Way way = (Way)it.next();
            it.remove();
            if (this.wayProcessed(way, waysToCombine)) continue;
            ArrayList<Way> list = new ArrayList<Way>();
            list.add(way);
            boolean finished = false;
            ArrayList sourceWays2 = new ArrayList(sourceWays);
            while (!finished) {
                int before = list.size();
                Iterator it2 = sourceWays2.iterator();
                while (it2.hasNext()) {
                    Way w2 = (Way)it2.next();
                    if (!this.wayBelongsTo(w2, list)) continue;
                    list.add(w2);
                    it2.remove();
                }
                int after = list.size();
                finished = after == before;
            }
            if (list.size() <= 1) continue;
            waysToCombine.add(list);
        }
        for (List list : waysToCombine) {
            try {
                WayCombiner.combineWays((Collection)list);
            }
            catch (UserCancelException e) {
                return;
            }
        }
        for (Way way : ds.getWays()) {
            if (way.getNodesCount() <= 3) {
                ds.removePrimitive((PrimitiveId)way);
                for (Node n : way.getNodes()) {
                    ds.removePrimitive((PrimitiveId)n);
                }
                continue;
            }
            way.put("amenity", "toilets");
        }
    }

    @Override
    protected String getDirectLink() {
        return "http://opendata.paris.fr/opendata/hn/sanisettes.zip";
    }
}

