/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.xml.XMLOutput;
import edu.umd.cs.findbugs.xml.XMLWriteable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public abstract class XMLOutputUtil {
    public static void writeElementList(XMLOutput xmlOutput, String tagName, Iterable<String> listValues) throws IOException {
        XMLOutputUtil.writeElementList(xmlOutput, tagName, listValues.iterator());
    }

    public static void writeElementList(XMLOutput xmlOutput, String tagName, Iterator<String> listValueIterator) throws IOException {
        while (listValueIterator.hasNext()) {
            xmlOutput.openTag(tagName);
            xmlOutput.writeText(listValueIterator.next());
            xmlOutput.closeTag(tagName);
        }
    }

    public static void writeFileList(XMLOutput xmlOutput, String tagName, Iterable<File> listValues) throws IOException {
        if (listValues != null) {
            XMLOutputUtil.writeFileList(xmlOutput, tagName, listValues.iterator());
        }
    }

    public static void writeFileList(XMLOutput xmlOutput, String tagName, Iterator<File> listValueIterator) throws IOException {
        while (listValueIterator.hasNext()) {
            xmlOutput.openTag(tagName);
            xmlOutput.writeText(listValueIterator.next().getPath());
            xmlOutput.closeTag(tagName);
        }
    }

    public static void writeCollection(XMLOutput xmlOutput, Collection<? extends XMLWriteable> collection) throws IOException {
        for (XMLWriteable xMLWriteable : collection) {
            xMLWriteable.writeXML(xmlOutput);
        }
    }
}

