/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnValueAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ArrayElementValue;
import org.apache.bcel.classfile.ClassElementValue;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.EnumElementValue;

public class BuildCheckReturnAnnotationDatabase
extends AnnotationVisitor {
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    @StaticConstant
    private static final Map<String, AnnotationDatabase.Target> defaultKind = new HashMap<String, AnnotationDatabase.Target>();

    static String simpleClassName(@DottedClassName String className) {
        int i = className.lastIndexOf(46);
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitAnnotation(@DottedClassName String annotationClassName, Map<String, ElementValue> map, boolean runtimeVisible) {
        CheckReturnValueAnnotation n;
        String annotationClassSimpleName = BuildCheckReturnAnnotationDatabase.simpleClassName(annotationClassName);
        if (annotationClassSimpleName.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
            AnnotationDatabase.Target annotationTarget = defaultKind.get(annotationClassSimpleName = annotationClassSimpleName.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
            if (annotationTarget != AnnotationDatabase.Target.METHOD) {
                return;
            }
            ElementValue v = map.get("value");
            if (v instanceof ClassElementValue) {
                this.handleClassElementValue((ClassElementValue)v, map, annotationTarget);
                return;
            } else {
                if (!(v instanceof ArrayElementValue)) return;
                for (ElementValue v2 : ((ArrayElementValue)v).getElementValuesArray()) {
                    if (!(v2 instanceof ClassElementValue)) continue;
                    this.handleClassElementValue((ClassElementValue)v2, map, annotationTarget);
                }
            }
            return;
        }
        if (annotationClassName.equals(javax.annotation.CheckReturnValue.class.getName())) {
            ElementValue v = map.get("when");
            if (v instanceof EnumElementValue) {
                EnumElementValue when = (EnumElementValue)v;
                String w = BuildCheckReturnAnnotationDatabase.simpleClassName(when.getEnumValueString());
                if ("NEVER".equals(w) || "UNKNOWN".equals(w)) {
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE;
                } else if ("MAYBE".equals(w)) {
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM_BAD_PRACTICE;
                } else {
                    if (!"ALWAYS".equals(w)) return;
                    n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_HIGH;
                }
            } else {
                n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
            }
        } else if (annotationClassName.equals(CheckReturnValue.class.getName())) {
            n = CheckReturnValueAnnotation.parse(BuildCheckReturnAnnotationDatabase.getAnnotationParameterAsString(map, "priority"));
        } else if ("CheckReturnValue".equals(annotationClassSimpleName)) {
            n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_MEDIUM;
        } else {
            if (!"CanIgnoreReturnValue".equals(annotationClassSimpleName)) return;
            n = CheckReturnValueAnnotation.CHECK_RETURN_VALUE_IGNORE;
        }
        if (n == null) {
            return;
        }
        if (this.visitingMethod()) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDirectAnnotation(XFactory.createXMethod(this), n);
            return;
        } else {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(AnnotationDatabase.Target.METHOD, this.getDottedClassName(), n);
        }
    }

    private void handleClassElementValue(ClassElementValue value, Map<String, ElementValue> map, AnnotationDatabase.Target annotationTarget) {
        CheckReturnValueAnnotation n;
        if ("CheckReturnValue".equals(BuildCheckReturnAnnotationDatabase.simpleClassName(value.getClassString())) && (n = CheckReturnValueAnnotation.parse(BuildCheckReturnAnnotationDatabase.getAnnotationParameterAsString(map, "priority"))) != null) {
            AnalysisContext.currentAnalysisContext().getCheckReturnAnnotationDatabase().addDefaultAnnotation(annotationTarget, this.getDottedClassName(), n);
        }
    }

    static {
        defaultKind.put("", AnnotationDatabase.Target.ANY);
        defaultKind.put("ForParameters", AnnotationDatabase.Target.PARAMETER);
        defaultKind.put("ForMethods", AnnotationDatabase.Target.METHOD);
        defaultKind.put("ForFields", AnnotationDatabase.Target.FIELD);
    }
}

