/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine;

import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.ICodeBase;
import edu.umd.cs.findbugs.classfile.ICodeBaseEntry;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.RecomputableClassAnalysisEngine;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassData;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBaseEntry;
import edu.umd.cs.findbugs.io.IO;
import java.io.IOException;
import java.io.InputStream;

public class ClassDataAnalysisEngine
extends RecomputableClassAnalysisEngine<ClassData> {
    @Override
    public ClassData analyze(IAnalysisCache analysisCache, ClassDescriptor descriptor) throws CheckedAnalysisException {
        byte[] data;
        ICodeBaseEntry codeBaseEntry;
        String resourceName = descriptor.toResourceName();
        try {
            codeBaseEntry = analysisCache.getClassPath().lookupResource(resourceName);
        }
        catch (ResourceNotFoundException e) {
            if (resourceName.startsWith("javax/annotation/")) {
                codeBaseEntry = new VirtualCodeBaseEntry(descriptor);
            }
            throw new MissingClassException(descriptor, (Throwable)e);
        }
        if (codeBaseEntry instanceof ZipInputStreamCodeBaseEntry) {
            data = ((ZipInputStreamCodeBaseEntry)codeBaseEntry).getBytes();
        } else {
            try {
                int length = codeBaseEntry.getNumBytes();
                InputStream in = codeBaseEntry.openResource();
                data = length >= 0 ? IO.readAll(in, length) : IO.readAll(in);
            }
            catch (IOException e) {
                throw new MissingClassException(descriptor, (Throwable)e);
            }
        }
        return new ClassData(descriptor, codeBaseEntry, data);
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerClassAnalysisEngine(ClassData.class, this);
    }

    private static class VirtualCodeBaseEntry
    implements ICodeBaseEntry {
        private final ClassDescriptor descriptor;

        public VirtualCodeBaseEntry(ClassDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public String getResourceName() {
            return this.descriptor.toResourceName();
        }

        @Override
        public int getNumBytes() {
            return -1;
        }

        @Override
        public InputStream openResource() throws IOException {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.descriptor.toResourceName());
            if (stream == null) {
                throw new IOException("Can not load '" + this.descriptor.toResourceName() + "' from SpotBugs classpath.");
            }
            return stream;
        }

        @Override
        public ICodeBase getCodeBase() {
            return null;
        }

        @Override
        public ClassDescriptor getClassDescriptor() {
            return this.descriptor;
        }

        @Override
        public void overrideResourceName(String resourceName) {
        }
    }
}

