/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGPrinter;
import edu.umd.cs.findbugs.ba.DFSEdgeTypes;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;

public class DFSCFGPrinter
extends CFGPrinter
implements DFSEdgeTypes {
    private final DepthFirstSearch dfs;

    public DFSCFGPrinter(CFG cfg, DepthFirstSearch dfs) {
        super(cfg);
        this.dfs = dfs;
    }

    @Override
    public String edgeAnnotate(Edge edge) {
        int dfsEdgeType = this.dfs.getDFSEdgeType(edge);
        switch (dfsEdgeType) {
            case -1: {
                return "UNKNOWN_EDGE";
            }
            case 0: {
                return "TREE_EDGE";
            }
            case 1: {
                return "BACK_EDGE";
            }
            case 3: {
                return "CROSS_EDGE";
            }
            case 2: {
                return "FORWARD_EDGE";
            }
        }
        throw new IllegalStateException("no DFS edge type?");
    }
}

