/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.io.IO;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;

public class BugRanker {
    public static final int VISIBLE_RANK_MAX = 20;
    public static final int VISIBLE_RANK_MIN = 1;
    static final boolean PLUGIN_DEBUG = Boolean.getBoolean("bugranker.plugin.debug");
    private final Scorer bugPatterns = new Scorer();
    private final Scorer bugKinds = new Scorer();
    private final Scorer bugCategories = new Scorer();
    public static final String FILENAME = "bugrank.txt";
    public static final String ADJUST_FILENAME = "adjustBugrank.txt";
    private static AnalysisLocal<HashMap<BugPattern, Integer>> rankForBugPattern = new AnalysisLocal<HashMap<BugPattern, Integer>>(){

        @Override
        protected HashMap<BugPattern, Integer> initialValue() {
            return new HashMap<BugPattern, Integer>();
        }
    };

    BugRanker(@CheckForNull URL u) throws IOException {
        if (u == null) {
            return;
        }
        try (BufferedReader in = UTF8.bufferedReader(IO.openNonCachedStream(u));){
            String s;
            while ((s = in.readLine()) != null) {
                if ((s = s.trim()).length() == 0) continue;
                String[] parts = s.split(" ");
                if (parts.length != 3) {
                    AnalysisContext.logError("Can't parse bug rank line: '" + s + "'. Valid line must contain 3 parts separated by spaces.");
                    continue;
                }
                String rank = parts[0];
                String kind = parts[1];
                String what = parts[2];
                if ("BugPattern".equals(kind)) {
                    this.bugPatterns.storeAdjustment(what, rank);
                    continue;
                }
                if ("BugKind".equals(kind)) {
                    this.bugKinds.storeAdjustment(what, rank);
                    continue;
                }
                if ("Category".equals(kind)) {
                    this.bugCategories.storeAdjustment(what, rank);
                    continue;
                }
                AnalysisContext.logError("Can't parse rank kind from line: '" + s + "'. Valid kind must be either 'BugPattern', 'BugKind' or 'Category'.");
            }
        }
    }

    private static int priorityAdjustment(int priority) {
        switch (priority) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 5;
            }
        }
        return 10;
    }

    private static int adjustRank(int patternRank, int priority) {
        int priorityAdjustment = BugRanker.priorityAdjustment(priority);
        if (patternRank > 20) {
            return patternRank + priorityAdjustment;
        }
        return Math.max(1, Math.min(patternRank + priorityAdjustment, 20));
    }

    private static int rankBugPattern(BugPattern bugPattern, BugRanker ... rankers) {
        String type = bugPattern.getType();
        int rank = 0;
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugPatterns.get(type);
            if (b.bugPatterns.isRelative(type)) continue;
            return rank;
        }
        String kind = bugPattern.getAbbrev();
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugKinds.get(kind);
            if (b.bugKinds.isRelative(kind)) continue;
            return rank;
        }
        String category = bugPattern.getCategory();
        for (BugRanker b : rankers) {
            if (b == null) continue;
            rank += b.bugCategories.get(category);
            if (b.bugCategories.isRelative(category)) continue;
            return rank;
        }
        return rank;
    }

    private static BugRanker getCoreRanker() {
        Plugin corePlugin = PluginLoader.getCorePluginLoader().getPlugin();
        return corePlugin.getBugRanker();
    }

    public static int findRank(BugInstance bug) {
        int patternRank = BugRanker.findRank(bug.getBugPattern(), bug.getDetectorFactory());
        return BugRanker.adjustRank(patternRank, bug.getPriority());
    }

    public static int findRank(BugPattern bugPattern, int priority) {
        int patternRank = BugRanker.findRank(bugPattern, null);
        return BugRanker.adjustRank(patternRank, priority);
    }

    public static int findRank(BugPattern pattern, @CheckForNull DetectorFactory detectorFactory) {
        BugRanker coreRanker;
        Plugin plugin;
        BugRanker pluginRanker;
        Integer cachedResult;
        boolean haveCache;
        boolean bl = haveCache = Global.getAnalysisCache() != null;
        if (haveCache && (cachedResult = rankForBugPattern.get().get(pattern)) != null) {
            return cachedResult;
        }
        int rank = detectorFactory == null ? BugRanker.findRankUnknownPlugin(pattern) : ((pluginRanker = (plugin = detectorFactory.getPlugin()).getBugRanker()) == (coreRanker = BugRanker.getCoreRanker()) ? BugRanker.rankBugPattern(pattern, coreRanker) : BugRanker.rankBugPattern(pattern, pluginRanker, coreRanker));
        if (haveCache) {
            rankForBugPattern.get().put(pattern, rank);
        }
        return rank;
    }

    private static int findRankUnknownPlugin(BugPattern pattern) {
        ArrayList<BugRanker> rankers = new ArrayList<BugRanker>();
        block0: for (Plugin plugin : Plugin.getAllPlugins()) {
            if (plugin.isCorePlugin()) continue;
            for (DetectorFactory df : plugin.getDetectorFactories()) {
                if (!df.getReportedBugPatterns().contains(pattern)) continue;
                if (PLUGIN_DEBUG) {
                    System.out.println("Bug rank match " + plugin + " " + df + " for " + pattern);
                }
                rankers.add(plugin.getBugRanker());
                continue block0;
            }
            if (!PLUGIN_DEBUG) continue;
            System.out.println("plugin " + plugin + " doesn't match " + pattern);
        }
        rankers.add(BugRanker.getCoreRanker());
        return BugRanker.rankBugPattern(pattern, rankers.toArray(new BugRanker[rankers.size()]));
    }

    public static void trimToMaxRank(BugCollection origCollection, int maxRank) {
        Iterator<BugInstance> i = origCollection.getCollection().iterator();
        while (i.hasNext()) {
            BugInstance b = i.next();
            if (BugRanker.findRank(b) <= maxRank) continue;
            i.remove();
        }
    }

    static class Scorer {
        private final HashMap<String, Integer> adjustment = new HashMap();
        private final HashSet<String> isRelative = new HashSet();

        Scorer() {
        }

        int get(String key) {
            Integer v = this.adjustment.get(key);
            if (v == null) {
                return 0;
            }
            return v;
        }

        boolean isRelative(String key) {
            return !this.adjustment.containsKey(key) || this.isRelative.contains(key);
        }

        void storeAdjustment(String key, String value) {
            for (String k : key.split(",")) {
                char firstChar = value.charAt(0);
                if (firstChar == '+') {
                    value = value.substring(1);
                }
                int v = Integer.parseInt(value);
                this.adjustment.put(k, v);
                if (firstChar != '+' && firstChar != '-') continue;
                this.isRelative.add(k);
            }
        }
    }
}

