/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import org.jacoco.asm.tree.AbstractInsnNode;
import org.jacoco.asm.tree.MethodNode;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;

public class KotlinLateinitFilter
implements IFilter {
    private static final String OWNER = "kotlin/jvm/internal/Intrinsics";
    private static final String NAME = "throwUninitializedPropertyAccessException";

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        for (AbstractInsnNode i = methodNode.instructions.getFirst(); i != null; i = i.getNext()) {
            AbstractInsnNode end;
            if (i.getOpcode() != 199 || (end = new Matcher(i).match()) == null) continue;
            output.ignore(i, end);
        }
    }

    private static class Matcher
    extends AbstractMatcher {
        private final AbstractInsnNode start;

        private Matcher(AbstractInsnNode start) {
            this.start = start;
        }

        private AbstractInsnNode match() {
            this.cursor = this.start;
            this.nextIs(18);
            this.nextIsInvokeStatic(KotlinLateinitFilter.OWNER, KotlinLateinitFilter.NAME);
            return this.cursor;
        }
    }
}

