/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.plugins.opendata.core.gui.ModuleListPanel;
import org.openstreetmap.josm.plugins.opendata.core.gui.ModulePreferencesModel;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleDownloadTask;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ReadLocalModuleInformationTask;
import org.openstreetmap.josm.plugins.opendata.core.modules.ReadRemoteModuleInformationTask;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ModulePreference
implements SubPreferenceSetting {
    private JTextField tfFilter;
    private final ModulePreferencesModel model = new ModulePreferencesModel();
    private final ModuleListPanel pnlModulePreferences = new ModuleListPanel(this.model);
    private JScrollPane spModulePreferences;
    private boolean modulePreferencesActivated = false;

    public static String buildDownloadSummary(ModuleDownloadTask task) {
        Collection<ModuleInformation> downloaded = task.getDownloadedModules();
        Collection<ModuleInformation> failed = task.getFailedModules();
        StringBuilder sb = new StringBuilder();
        if (!downloaded.isEmpty()) {
            sb.append(I18n.trn((String)"The following module has been downloaded <strong>successfully</strong>:", (String)"The following {0} modules have been downloaded <strong>successfully</strong>:", (long)downloaded.size(), (Object[])new Object[]{downloaded.size()}));
            sb.append("<ul>");
            for (ModuleInformation pi : downloaded) {
                sb.append("<li>").append(pi.name).append(" (").append(pi.version).append(")").append("</li>");
            }
            sb.append("</ul>");
        }
        if (!failed.isEmpty()) {
            sb.append(I18n.trn((String)"Downloading the following module has <strong>failed</strong>:", (String)"Downloading the following {0} modules has <strong>failed</strong>:", (long)failed.size(), (Object[])new Object[]{failed.size()}));
            sb.append("<ul>");
            for (ModuleInformation pi : failed) {
                sb.append("<li>").append(pi.name).append("</li>");
            }
            sb.append("</ul>");
        }
        return sb.toString();
    }

    protected JPanel buildSearchFieldPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 0, 3);
        pnl.add((Component)new JLabel(I18n.tr((String)"Search:", (Object[])new Object[0])), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfFilter = new JTextField();
        pnl.add((Component)this.tfFilter, gc);
        this.tfFilter.setToolTipText(I18n.tr((String)"Enter a search expression", (Object[])new Object[0]));
        SelectAllOnFocusGainedDecorator.decorate((JTextComponent)this.tfFilter);
        this.tfFilter.getDocument().addDocumentListener(new SearchFieldAdapter());
        return pnl;
    }

    protected JPanel buildActionPanel() {
        JPanel pnl = new JPanel(new GridLayout(1, 3));
        pnl.add(new JButton(new DownloadAvailableModulesAction()));
        pnl.add(new JButton(new UpdateSelectedModulesAction()));
        pnl.add(new JButton(new ConfigureSitesAction()));
        return pnl;
    }

    protected JPanel buildModuleListPanel() {
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.buildSearchFieldPanel(), "North");
        this.spModulePreferences = new JScrollPane((Component)((Object)this.pnlModulePreferences));
        this.spModulePreferences.setHorizontalScrollBarPolicy(31);
        this.spModulePreferences.setVerticalScrollBarPolicy(20);
        this.spModulePreferences.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                ModulePreference.this.spModulePreferences.setBorder(UIManager.getBorder("ScrollPane.border"));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ModulePreference.this.spModulePreferences.setBorder(null);
            }
        });
        pnl.add((Component)this.spModulePreferences, "Center");
        pnl.add((Component)this.buildActionPanel(), "South");
        return pnl;
    }

    public void addGui(PreferenceTabbedPane gui) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 18;
        gc.fill = 1;
        OdPreferenceSetting settings = (OdPreferenceSetting)((Object)gui.getSetting(OdPreferenceSetting.class));
        settings.tabPane.addTab(I18n.tr((String)"Modules", (Object[])new Object[0]), this.buildModuleListPanel());
        this.pnlModulePreferences.refreshView();
        gui.addChangeListener((ChangeListener)new ModulePreferenceActivationListener(settings.masterPanel));
    }

    private void configureSites() {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"OK", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"ok"), I18n.tr((String)"Accept the new module sites and close the dialog", (Object[])new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr((String)"Cancel", (Object[])new Object[0]), (Icon)ImageProvider.get((String)"cancel"), I18n.tr((String)"Close the dialog", (Object[])new Object[0]), null)};
        ModuleConfigurationSitesPanel pnl = new ModuleConfigurationSitesPanel();
        int answer = HelpAwareOptionPane.showOptionDialog((Component)((Object)this.pnlModulePreferences), (Object)pnl, (String)I18n.tr((String)"Configure Module Sites", (Object[])new Object[0]), (int)3, null, (HelpAwareOptionPane.ButtonSpec[])options, (HelpAwareOptionPane.ButtonSpec)options[0], null);
        if (answer != 0) {
            return;
        }
        List<String> sites = pnl.getUpdateSites();
        OdPreferenceSetting.setModuleSites(sites);
    }

    public List<ModuleInformation> getModulesScheduledForUpdateOrDownload() {
        return this.model != null ? this.model.getModulesScheduledForUpdateOrDownload() : null;
    }

    public boolean ok() {
        if (!this.modulePreferencesActivated) {
            return false;
        }
        if (this.model.isActiveModulesChanged()) {
            LinkedList<String> l = new LinkedList<String>(this.model.getSelectedModuleNames());
            Collections.sort(l);
            Config.getPref().putList("opendata.modules", l);
            return true;
        }
        return false;
    }

    public void readLocalModuleInformation() {
        ReadLocalModuleInformationTask task = new ReadLocalModuleInformationTask();
        Runnable r = () -> {
            if (task.isCanceled()) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                this.model.setAvailableModules(task.getAvailableModules());
                this.pnlModulePreferences.refreshView();
            });
        };
        MainApplication.worker.submit((Runnable)((Object)task));
        MainApplication.worker.submit(r);
    }

    public boolean isExpert() {
        return false;
    }

    public TabPreferenceSetting getTabPreferenceSetting(PreferenceTabbedPane gui) {
        return (TabPreferenceSetting)gui.getSetting(OdPreferenceSetting.class);
    }

    private static class ModuleConfigurationSitesPanel
    extends JPanel {
        private DefaultListModel<String> model;

        protected void build() {
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel(I18n.tr((String)"Add Open Data Module description URL.", (Object[])new Object[0])), GBC.eol());
            this.model = new DefaultListModel();
            for (String s : OdPreferenceSetting.getModuleSites()) {
                this.model.addElement(s);
            }
            final JList<String> list = new JList<String>(this.model);
            this.add((Component)new JScrollPane(list), GBC.std().fill());
            JPanel buttons = new JPanel(new GridBagLayout());
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr((String)"Add", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = JOptionPane.showInputDialog(JOptionPane.getFrameForComponent(this), I18n.tr((String)"Add Open Data Module description URL.", (Object[])new Object[0]), I18n.tr((String)"Enter URL", (Object[])new Object[0]), 3);
                    if (s != null) {
                        model.addElement(s);
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr((String)"Edit", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), I18n.tr((String)"Please select an entry.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                        return;
                    }
                    String s = (String)JOptionPane.showInputDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Edit Open Data Module description URL.", (Object[])new Object[0]), I18n.tr((String)"Open Data Module description URL", (Object[])new Object[0]), 3, null, null, list.getSelectedValue());
                    if (s != null) {
                        model.setElementAt(s, list.getSelectedIndex());
                    }
                }
            }), GBC.eol().fill(2));
            buttons.add((Component)new JButton(new AbstractAction(I18n.tr((String)"Delete", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (list.getSelectedValue() == null) {
                        JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(this), I18n.tr((String)"Please select an entry.", (Object[])new Object[0]), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
                        return;
                    }
                    model.removeElement(list.getSelectedValue());
                }
            }), GBC.eol().fill(2));
            this.add((Component)buttons, GBC.eol());
        }

        ModuleConfigurationSitesPanel() {
            this.build();
        }

        public List<String> getUpdateSites() {
            if (this.model.getSize() == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> ret = new ArrayList<String>(this.model.getSize());
            for (int i = 0; i < this.model.getSize(); ++i) {
                ret.add(this.model.get(i));
            }
            return ret;
        }
    }

    class SearchFieldAdapter
    implements DocumentListener {
        SearchFieldAdapter() {
        }

        public void filter() {
            String expr = ModulePreference.this.tfFilter.getText().trim();
            if (expr.equals("")) {
                expr = null;
            }
            ModulePreference.this.model.filterDisplayedModules(expr);
            ModulePreference.this.pnlModulePreferences.refreshView();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            this.filter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            this.filter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            this.filter();
        }
    }

    class ModulePreferenceActivationListener
    implements ChangeListener {
        private Component pane;

        ModulePreferenceActivationListener(Component preferencesPane) {
            this.pane = preferencesPane;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JTabbedPane tp = (JTabbedPane)e.getSource();
            if (tp.getSelectedComponent() == this.pane) {
                ModulePreference.this.readLocalModuleInformation();
                ModulePreference.this.modulePreferencesActivated = true;
            }
        }
    }

    class ConfigureSitesAction
    extends AbstractAction {
        ConfigureSitesAction() {
            this.putValue("Name", I18n.tr((String)"Configure sites...", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Configure the list of sites where modules are downloaded from", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"settings"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModulePreference.this.configureSites();
        }
    }

    class UpdateSelectedModulesAction
    extends AbstractAction {
        UpdateSelectedModulesAction() {
            this.putValue("Name", I18n.tr((String)"Update modules", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Update the selected modules", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"dialogs", (String)"refresh"));
        }

        protected void notifyDownloadResults(ModuleDownloadTask task) {
            Collection<ModuleInformation> downloaded = task.getDownloadedModules();
            Collection<ModuleInformation> failed = task.getFailedModules();
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(ModulePreference.buildDownloadSummary(task));
            if (!downloaded.isEmpty()) {
                sb.append(I18n.tr((String)"Please restart JOSM to activate the downloaded modules.", (Object[])new Object[0]));
            }
            sb.append("</html>");
            HelpAwareOptionPane.showOptionDialog((Component)((Object)ModulePreference.this.pnlModulePreferences), (Object)sb.toString(), (String)I18n.tr((String)"Update modules", (Object[])new Object[0]), (int)(!failed.isEmpty() ? 2 : 1), (String)HelpUtil.ht((String)"/Preferences/Modules"));
        }

        protected void alertNothingToUpdate() {
            GuiHelper.runInEDTAndWait(() -> HelpAwareOptionPane.showOptionDialog((Component)((Object)ModulePreference.this.pnlModulePreferences), (Object)I18n.tr((String)"All installed modules are up to date. JOSM does not have to download newer versions.", (Object[])new Object[0]), (String)I18n.tr((String)"Modules up to date", (Object[])new Object[0]), (int)1, null));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ModuleInformation> toUpdate = ModulePreference.this.model.getSelectedModules();
            ModuleDownloadTask moduleDownloadTask = new ModuleDownloadTask((Component)((Object)ModulePreference.this.pnlModulePreferences), toUpdate, I18n.tr((String)"Update modules", (Object[])new Object[0]));
            ReadRemoteModuleInformationTask moduleInfoDownloadTask = new ReadRemoteModuleInformationTask(OdPreferenceSetting.getModuleSites());
            Runnable moduleDownloadContinuation = () -> {
                if (moduleDownloadTask.isCanceled()) {
                    return;
                }
                this.notifyDownloadResults(moduleDownloadTask);
                ModulePreference.this.model.refreshLocalModuleVersion(moduleDownloadTask.getDownloadedModules());
                ModulePreference.this.model.clearPendingModules(moduleDownloadTask.getDownloadedModules());
                GuiHelper.runInEDT((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ModulePreference.this.pnlModulePreferences.refreshView();
                    }
                });
            };
            Runnable moduleInfoDownloadContinuation = () -> {
                if (moduleInfoDownloadTask.isCanceled()) {
                    return;
                }
                ModulePreference.this.model.updateAvailableModules(moduleInfoDownloadTask.getAvailableModules());
                Iterator it = toUpdate.iterator();
                while (it.hasNext()) {
                    ModuleInformation pi = (ModuleInformation)it.next();
                    if (pi.isUpdateRequired()) continue;
                    it.remove();
                }
                if (toUpdate.isEmpty()) {
                    this.alertNothingToUpdate();
                    return;
                }
                moduleDownloadTask.setModulesToDownload(toUpdate);
                MainApplication.worker.submit((Runnable)((Object)moduleDownloadTask));
                MainApplication.worker.submit(moduleDownloadContinuation);
            };
            MainApplication.worker.submit((Runnable)((Object)moduleInfoDownloadTask));
            MainApplication.worker.submit(moduleInfoDownloadContinuation);
        }
    }

    class DownloadAvailableModulesAction
    extends AbstractAction {
        DownloadAvailableModulesAction() {
            this.putValue("Name", I18n.tr((String)"Download list", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Download the list of available modules", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"download"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ReadRemoteModuleInformationTask task = new ReadRemoteModuleInformationTask(OdPreferenceSetting.getModuleSites());
            Runnable continuation = () -> {
                if (task.isCanceled()) {
                    return;
                }
                SwingUtilities.invokeLater(() -> {
                    ModulePreference.this.model.updateAvailableModules(task.getAvailableModules());
                    ModulePreference.this.pnlModulePreferences.refreshView();
                });
            };
            MainApplication.worker.submit((Runnable)((Object)task));
            MainApplication.worker.submit(continuation);
        }
    }
}

