/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.openstreetmap.josm.plugins.tofix.oauth.OAuthParameters;
import org.openstreetmap.josm.plugins.tofix.oauth.OAuthToken;
import org.openstreetmap.josm.plugins.tofix.oauth.OsmPrivileges;
import org.openstreetmap.josm.plugins.tofix.oauth.SessionId;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.OAuthConsumer;
import org.openstreetmap.josm.plugins.tofix.oauth.signpost.OAuthProvider;
import org.openstreetmap.josm.plugins.tofix.util.HttpClient;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class OAuthClient {
    static String API_URL = Config.getUrls().getDefaultOsmApiUrl();
    static String OSM_WEBSITE = Config.getUrls().getOSMWebsite();
    private OAuthParameters oauthProviderParameters;
    private OAuthConsumer consumer;
    private OAuthProvider provider;
    private OAuthParameters parameters = OAuthParameters.createDefault(API_URL);

    public OAuthClient() {
        CheckParameterUtil.ensureParameterNotNull((Object)this.parameters, (String)"parameters");
        this.oauthProviderParameters = new OAuthParameters(this.parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
    }

    public OAuthClient(OAuthToken requestToken) {
        CheckParameterUtil.ensureParameterNotNull((Object)this.parameters, (String)"parameters");
        this.oauthProviderParameters = new OAuthParameters(this.parameters);
        this.consumer = this.oauthProviderParameters.buildConsumer();
        this.provider = this.oauthProviderParameters.buildProvider(this.consumer);
        this.consumer.setTokenWithSecret(requestToken.getKey(), requestToken.getSecret());
    }

    public static OsmPrivileges getPrivileges() {
        OsmPrivileges privileges = new OsmPrivileges();
        privileges.setAllowWriteApi(true);
        privileges.setAllowWriteGpx(true);
        privileges.setAllowReadGpx(true);
        privileges.setAllowWritePrefs(true);
        privileges.setAllowReadPrefs(true);
        privileges.setAllowModifyNotes(true);
        return privileges;
    }

    public OAuthToken getRequestToken() throws Exception {
        try {
            this.provider.retrieveRequestToken(this.consumer, "", new String[0]);
            OAuthToken oAuthToken = OAuthToken.createToken(this.consumer);
            return oAuthToken;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            Logging.info((String)"Finish RequestToken!!!");
        }
    }

    private String getAuthoriseUrl(OAuthToken requestToken) {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.oauthProviderParameters.getAuthoriseUrl()).append("?oauth_token=").append(requestToken.getKey());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOAuthToken(SessionId sessionId, OAuthToken requestToken) throws Exception {
        HttpClient connection = null;
        try {
            URL url = new URL(this.getAuthoriseUrl(requestToken));
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                connection = HttpClient.create(url).useCache(false).setHeader("Cookie", "_osm_session=" + sessionId.getId() + "; _osm_username=" + sessionId.getUserName());
                connection.connect();
            }
            sessionId.setToken(this.extractToken(connection));
            if (sessionId.getToken() == null) {
                throw new Exception(I18n.tr((String)"OSM website did not return a session cookie in response to ''{0}'',", (Object[])new Object[]{url.toString()}));
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                connection = null;
            }
            Logging.info((String)"Finish OAuthToken!!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionId getOsmWebsiteSessionId(String u) throws Exception {
        SessionId sessionId;
        HttpClient connection = null;
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLoginUrl() + "?cookie_test=true");
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                connection = HttpClient.create(url).useCache(false);
                connection.connect();
            }
            sessionId = this.extractOsmSession(connection);
            if (sessionId == null) {
                throw new Exception(I18n.tr((String)"OSM website did not return a session cookie in response to ''{0}'',", (Object[])new Object[]{url.toString()}));
            }
            sessionId.setUserName(u);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
            }
        }
        return sessionId;
    }

    private static String buildPostRequest(Map<String, String> parameters) {
        StringBuilder sb = new StringBuilder(32);
        Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String value = entry.getValue();
            value = value == null ? "" : value;
            sb.append(entry.getKey()).append('=').append(Utils.encodeUrl((String)value));
            if (!it.hasNext()) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionId login(String userName, String password) throws Exception {
        SessionId sessionId = null;
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLoginUrl());
            HttpClient connection = HttpClient.create(url, "POST").useCache(false);
            sessionId = this.getOsmWebsiteSessionId(userName);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("username", userName);
            parameters.put("password", password);
            parameters.put("referer", "/");
            parameters.put("commit", "Login");
            parameters.put("authenticity_token", sessionId.getToken());
            connection.setRequestBody(OAuthClient.buildPostRequest(parameters).getBytes(StandardCharsets.UTF_8));
            connection.setHeader("Content-Type", "application/x-www-form-urlencoded");
            connection.setHeader("Cookie", "_osm_session=" + sessionId.getId());
            connection.setMaxRedirects(-1);
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                connection.connect();
            }
            int retCode = connection.getResponse().getResponseCode();
            if (retCode != 302) {
                throw new Exception(I18n.tr((String)"Failed to authenticate user ''{0}'' with password ''***'' as OAuth user", (Object[])new Object[]{userName}));
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                Object connection = null;
            }
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(SessionId sessionId) throws Exception {
        try {
            URL url = new URL(this.oauthProviderParameters.getOsmLogoutUrl());
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                HttpClient connection = HttpClient.create(url).setMaxRedirects(-1);
                connection.connect();
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                Object connection = null;
            }
            Logging.info((String)"Logout OSM Session!!!");
        }
    }

    private SessionId extractOsmSession(HttpClient connection) throws IOException, URISyntaxException {
        List<String> setCookies = CookieHandler.getDefault().get(connection.getURL().toURI(), Collections.emptyMap()).get("Cookie");
        if (setCookies == null) {
            Logging.warn((String)"No 'Set-Cookie' in response header!");
            return null;
        }
        for (String setCookie : setCookies) {
            String[] kvPairs = setCookie.split(";");
            if (kvPairs.length == 0) continue;
            for (String kvPair : kvPairs) {
                String[] kv = (kvPair = kvPair.trim()).split("=");
                if (kv.length != 2 || !"_osm_session".equals(kv[0])) continue;
                String token = this.extractToken(connection);
                if (token == null) {
                    return null;
                }
                SessionId si = new SessionId();
                si.setId(kv[1]);
                si.setToken(token);
                return si;
            }
        }
        Logging.warn((String)"No suitable 'Set-Cookie' in response header found! {0}", (Object[])new Object[]{setCookies});
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractToken(HttpClient connection) {
        try (BufferedReader r = connection.getResponse().getContentReader();){
            String c;
            Pattern p = Pattern.compile(".*authenticity_token.*value=\"([^\"]+)\".*");
            while ((c = r.readLine()) != null) {
                Matcher m = p.matcher(c);
                if (!m.find()) continue;
                String string = m.group(1);
                return string;
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            return null;
        }
        Logging.warn((String)"No authenticity_token found in response!");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAuthorisationRequest(SessionId sessionId, OAuthToken requestToken, OsmPrivileges privileges) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.getOAuthToken(sessionId, requestToken);
        parameters.put("oauth_token", requestToken.getKey());
        parameters.put("oauth_callback", "");
        parameters.put("authenticity_token", sessionId.getToken());
        if (privileges.isAllowWriteApi()) {
            parameters.put("allow_write_api", "yes");
        }
        if (privileges.isAllowWriteGpx()) {
            parameters.put("allow_write_gpx", "yes");
        }
        if (privileges.isAllowReadGpx()) {
            parameters.put("allow_read_gpx", "yes");
        }
        if (privileges.isAllowWritePrefs()) {
            parameters.put("allow_write_prefs", "yes");
        }
        if (privileges.isAllowReadPrefs()) {
            parameters.put("allow_read_prefs", "yes");
        }
        if (privileges.isAllowModifyNotes()) {
            parameters.put("allow_write_notes", "yes");
        }
        parameters.put("commit", "Save changes");
        String request = OAuthClient.buildPostRequest(parameters);
        try {
            URL url = new URL(this.oauthProviderParameters.getAuthoriseUrl());
            HttpClient connection = HttpClient.create(url, "POST").useCache(false);
            connection.setHeader("Content-Type", "application/x-www-form-urlencoded");
            connection.setHeader("Cookie", "_osm_session=" + sessionId.getId() + "; _osm_username=" + sessionId.getUserName());
            connection.setMaxRedirects(-1);
            connection.setRequestBody(request.getBytes(StandardCharsets.UTF_8));
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                connection.connect();
            }
            int retCode = connection.getResponse().getResponseCode();
            if (retCode != 200) {
                throw new Exception(I18n.tr((String)"Failed to authorize OAuth request  ''{0}''", (Object[])new Object[]{requestToken.getKey()}));
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            OAuthClient oAuthClient = this;
            synchronized (oAuthClient) {
                Object connection = null;
            }
        }
    }

    public SessionId authorise(String userName, String password, OsmPrivileges privileges) throws Exception {
        SessionId sessionId;
        OAuthToken requestToken = this.getRequestToken();
        CheckParameterUtil.ensureParameterNotNull((Object)requestToken, (String)"requestToken");
        CheckParameterUtil.ensureParameterNotNull((Object)userName, (String)"userName");
        CheckParameterUtil.ensureParameterNotNull((Object)password, (String)"password");
        CheckParameterUtil.ensureParameterNotNull((Object)privileges, (String)"privileges");
        try {
            Logging.info((String)I18n.tr((String)"Authorizing OAuth Request token ''{0}'' at the OSM website ...", (Object[])new Object[]{requestToken.getKey()}));
            Logging.info((String)I18n.tr((String)"Initializing a session at the OSM website...", (Object[])new Object[0]));
            sessionId = this.login(userName, password);
            Logging.info((String)I18n.tr((String)"Authenticating the session for user ''{0}''...", (Object[])new Object[]{userName}));
            Logging.info((String)I18n.tr((String)"Authorizing request token ''{0}''...", (Object[])new Object[]{requestToken.getKey()}));
            this.sendAuthorisationRequest(sessionId, requestToken, privileges);
            Logging.info((String)I18n.tr((String)"Logging out session ''{0}''...", (Object[])new Object[]{sessionId}));
            this.logout(sessionId);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            Logging.info((String)"Finish Authorise!!!");
        }
        return sessionId;
    }

    public static JsonObject getOSMUserInfo(String user) throws Exception {
        String _url = "http://hdyc.neis-one.org/users/" + user;
        URL url = null;
        BufferedReader reader = null;
        try {
            JsonObject jsonObject;
            url = new URL(_url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(15000);
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line + "\n");
            }
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(stringBuilder.toString()));
            JsonObject jsonObject2 = jsonObject = jsonReader.readObject();
            return jsonObject2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    Logging.error((Throwable)ioe);
                }
            }
        }
    }

    public static JsonObject authTofixBackend(SessionId sessionId, OAuthToken requestToken) throws Exception {
        String _url = org.openstreetmap.josm.plugins.tofix.util.Config.getAPILogin() + "/josm";
        JsonObject userInfo = OAuthClient.getOSMUserInfo(sessionId.getUserName()).getJsonObject("contributor");
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("name", userInfo.getString("name"));
        params.put("id", userInfo.getString("uid"));
        String img = userInfo.getString("img");
        params.put("image", img);
        params.put("key", requestToken.getKey());
        params.put("secret", requestToken.getSecret());
        params.put("oauth_token", sessionId.getToken());
        StringBuilder postData = new StringBuilder("?");
        for (Map.Entry param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        byte[] getDataBytes = postData.toString().getBytes("UTF-8");
        URL url = null;
        BufferedReader reader = null;
        try {
            JsonObject jsonObject;
            url = new URL(_url + new String(getDataBytes, StandardCharsets.UTF_8));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setReadTimeout(15000);
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
            StringBuilder stringBuilder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line + "\n");
            }
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(stringBuilder.toString()));
            JsonObject jsonObject2 = jsonObject = jsonReader.readObject();
            return jsonObject2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    Logging.error((Throwable)ioe);
                }
            }
        }
    }
}

