/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.tofix;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.openstreetmap.josm.actions.UploadAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.io.UploadDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.mappaint.mapcss.ExpressionFactory;
import org.openstreetmap.josm.plugins.tofix.JDHost;
import org.openstreetmap.josm.plugins.tofix.JDOAuth;
import org.openstreetmap.josm.plugins.tofix.TofixProject;
import org.openstreetmap.josm.plugins.tofix.bean.AccessToProject;
import org.openstreetmap.josm.plugins.tofix.bean.ItemBean;
import org.openstreetmap.josm.plugins.tofix.bean.ListProjectBean;
import org.openstreetmap.josm.plugins.tofix.bean.ProjectBean;
import org.openstreetmap.josm.plugins.tofix.controller.ItemController;
import org.openstreetmap.josm.plugins.tofix.controller.ItemTrackController;
import org.openstreetmap.josm.plugins.tofix.controller.ListProjectsController;
import org.openstreetmap.josm.plugins.tofix.util.Config;
import org.openstreetmap.josm.plugins.tofix.util.Status;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public final class TofixDialog
extends ToggleDialog
implements ActionListener {
    MapView mv;
    ItemTrackController itemTrackController;
    JTabbedPane TabbedPanel;
    JPanel jContentPanelProjects;
    JPanel jContenActivation;
    JPanel jPanelProjects;
    JPanel jPanelQuery;
    private JDOAuth oauth;
    private JDHost host;
    private final SideButton skipButton;
    private final SideButton fixedButton;
    private final SideButton noterrorButton;
    private final JTextField bboxJtextField;
    private final Shortcut skipShortcut;
    private final Shortcut fixedShortcut;
    private final Shortcut noterrorButtonShortcut;
    private final JComboBox<String> jcomboBox;
    private final JCheckBox jCheckBoxToken;
    private final JCheckBox jCheckBoxDeleteLayer;
    private final JCheckBox jCheckBoxSetNewAPI;
    private final JCheckBox jCheckBoxDownloadOSMData;
    private final JCheckBox jCheckBoxSetDataEditable;
    private final JCheckBox jCheckBoxSetBbox;
    double zise;
    boolean validator;
    private boolean needDeleteLayer;
    private boolean isCheckedDownloadOSMData;
    private boolean isCheckedEditableData;
    ArrayList<String> listStringsForCombo;
    AccessToProject mainAccessToProject;
    ProjectBean project;
    ListProjectsController listProjectController;
    ListProjectBean projectsList;
    ItemBean item;
    ItemController itemController;
    TofixProject tofixProject;

    public TofixDialog() {
        super(ExpressionFactory.Functions.tr((String[])new String[]{"To-fix"}), "icontofix", ExpressionFactory.Functions.tr((String[])new String[]{"Open to-fix window."}), Shortcut.registerShortcut((String)"Tool:To-fix", (String)ExpressionFactory.Functions.tr((String[])new String[]{"Toggle: {0}", ExpressionFactory.Functions.tr((String[])new String[]{"Tool:To-fix"})}), (int)84, (int)5010), 170);
        this.mv = MainApplication.getMap().mapView;
        this.itemTrackController = new ItemTrackController();
        this.TabbedPanel = new JTabbedPane();
        this.jContentPanelProjects = new JPanel(new GridLayout(1, 1));
        this.jContenActivation = new JPanel(new GridLayout(6, 1));
        this.jPanelProjects = new JPanel(new GridLayout(1, 1));
        this.jPanelQuery = new JPanel(new GridLayout(2, 1));
        this.zise = 6.0E-4;
        this.isCheckedDownloadOSMData = true;
        this.isCheckedEditableData = false;
        this.listStringsForCombo = new ArrayList();
        this.mainAccessToProject = null;
        this.project = new ProjectBean();
        this.listProjectController = new ListProjectsController();
        this.projectsList = null;
        this.item = new ItemBean();
        this.itemController = new ItemController();
        this.tofixProject = new TofixProject();
        this.listStringsForCombo.add(ExpressionFactory.Functions.tr((String[])new String[]{"Select a project ..."}));
        this.jcomboBox = new JComboBox<String>(this.listStringsForCombo.toArray(new String[0]));
        this.jcomboBox.addActionListener(this);
        this.jPanelProjects.add(this.jcomboBox);
        this.jContentPanelProjects.add(this.jPanelProjects);
        this.jContenActivation.add(new Label(ExpressionFactory.Functions.tr((String[])new String[]{"Select the checkbox to:"})));
        this.jCheckBoxSetNewAPI = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Set default API"}));
        this.jCheckBoxSetNewAPI.addActionListener(e -> {
            if (!this.jCheckBoxSetNewAPI.isSelected()) {
                this.setHost();
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), ExpressionFactory.Functions.tr((String[])new String[]{"Setting default API Host"}), ExpressionFactory.Functions.tr((String[])new String[]{"Confirmation"}), 1);
                Config.preferences(1, new String[]{"tofix-server.host", "http://tofix.devseed.com:8000"}, Config.getPluginPreferencesFile().getAbsolutePath());
            }
        });
        this.jCheckBoxSetNewAPI.setBorderPainted(true);
        this.jContenActivation.add(this.jCheckBoxSetNewAPI);
        this.jCheckBoxToken = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Set default Token"}));
        this.jCheckBoxToken.addActionListener(e -> {
            if (!this.jCheckBoxToken.isSelected()) {
                this.setToken();
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), ExpressionFactory.Functions.tr((String[])new String[]{"Setting default Token"}), ExpressionFactory.Functions.tr((String[])new String[]{"Confirmation"}), 1);
                Config.preferences(1, new String[]{"tofix-server.token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IjgwNTIxNTEiLCJ1c2VybmFtZSI6InRvZml4am9zbSIsImltYWdlIjoiIn0.05dWZsiq1aSxlPqP12oUdWEuyBI4nRh1zEZrBu6iBKA"}, Config.getPluginPreferencesFile().getAbsolutePath());
            }
        });
        this.jCheckBoxToken.setBorderPainted(true);
        this.jContenActivation.add(this.jCheckBoxToken);
        this.jCheckBoxDeleteLayer = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Auto delete layer"}));
        this.jCheckBoxDeleteLayer.setSelected(true);
        this.needDeleteLayer = this.jCheckBoxDeleteLayer.isSelected();
        this.jCheckBoxDeleteLayer.addItemListener(e -> {
            this.needDeleteLayer = e.getStateChange() == 1;
        });
        this.jCheckBoxDeleteLayer.setBorderPainted(true);
        this.jContenActivation.add(this.jCheckBoxDeleteLayer);
        this.jCheckBoxDownloadOSMData = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Download OSM Data"}));
        this.jCheckBoxDownloadOSMData.setSelected(true);
        this.jCheckBoxDownloadOSMData.addItemListener(e -> {
            this.isCheckedDownloadOSMData = e.getStateChange() == 1;
        });
        this.jCheckBoxDownloadOSMData.setBorderPainted(true);
        this.jContenActivation.add(this.jCheckBoxDownloadOSMData);
        this.jCheckBoxSetDataEditable = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Set editable layer"}));
        this.jCheckBoxSetDataEditable.setSelected(false);
        this.jCheckBoxSetDataEditable.addItemListener(e -> {
            boolean bl = this.isCheckedEditableData = e.getStateChange() == 1;
            if (this.isCheckedEditableData) {
                this.jCheckBoxDeleteLayer.setSelected(false);
            }
        });
        this.jCheckBoxSetDataEditable.setBorderPainted(true);
        this.jContenActivation.add(this.jCheckBoxSetDataEditable);
        this.jCheckBoxSetBbox = new JCheckBox(ExpressionFactory.Functions.tr((String[])new String[]{"Set BBox to request the items"}));
        this.jCheckBoxSetBbox.setSelected(false);
        this.bboxJtextField = new JTextField();
        this.jCheckBoxSetBbox.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                Bounds bounds;
                Layer layer = this.mv.getLayerManager().getActiveLayer();
                if (layer.isSavable()) {
                    ProjectionBounds projectionBounds = layer.getViewProjectionBounds();
                    LatLon minLatlon = ProjectionRegistry.getProjection().eastNorth2latlon(projectionBounds.getMin());
                    LatLon maxLatlon = ProjectionRegistry.getProjection().eastNorth2latlon(projectionBounds.getMax());
                    bounds = new Bounds(minLatlon, maxLatlon);
                } else {
                    bounds = this.mv.getRealBounds();
                }
                String bbox = String.valueOf(bounds.getMinLon()) + "," + String.valueOf(bounds.getMinLat()) + "," + String.valueOf(bounds.getMaxLon()) + "," + String.valueOf(bounds.getMaxLat());
                this.bboxJtextField.setText(bbox);
                Config.setBBOX(bbox);
            } else {
                this.bboxJtextField.setText("");
                Config.setBBOX("none");
            }
        });
        this.jPanelQuery.add(this.jCheckBoxSetBbox);
        this.jPanelQuery.add(this.bboxJtextField);
        this.skipButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", ExpressionFactory.Functions.tr((String[])new String[]{"Skip"}));
                new ImageProvider("mapmode", "skip").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", ExpressionFactory.Functions.tr((String[])new String[]{"Skip Error"}));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TofixDialog.this.skip();
                TofixDialog.this.deleteLayer();
            }
        });
        this.skipButton.setEnabled(false);
        this.skipShortcut = Shortcut.registerShortcut((String)"tofix:skip", (String)ExpressionFactory.Functions.tr((String[])new String[]{"tofix:Skip item"}), (int)83, (int)5007);
        MainApplication.registerActionShortcut((Action)new skipKeyAction(), (Shortcut)this.skipShortcut);
        this.fixedButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", ExpressionFactory.Functions.tr((String[])new String[]{"Fixed"}));
                new ImageProvider("mapmode", "fixed").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", ExpressionFactory.Functions.tr((String[])new String[]{"Fixed Error"}));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TofixDialog.this.eventFixed(e);
            }
        });
        this.fixedButton.setEnabled(false);
        this.fixedShortcut = Shortcut.registerShortcut((String)"tofix:fixed", (String)ExpressionFactory.Functions.tr((String[])new String[]{"tofix:Fixed item"}), (int)70, (int)5007);
        MainApplication.registerActionShortcut((Action)new fixedKeyAction(), (Shortcut)this.fixedShortcut);
        this.noterrorButton = new SideButton((Action)new AbstractAction(){
            {
                this.putValue("Name", ExpressionFactory.Functions.tr((String[])new String[]{"Not an error"}));
                new ImageProvider("mapmode", "noterror").getResource().attachImageIcon((AbstractAction)this, true);
                this.putValue("ShortDescription", ExpressionFactory.Functions.tr((String[])new String[]{"Not an error"}));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                TofixDialog.this.notError();
                TofixDialog.this.deleteLayer();
            }
        });
        this.noterrorButton.setEnabled(false);
        this.noterrorButtonShortcut = Shortcut.registerShortcut((String)"tofix:noterror", (String)ExpressionFactory.Functions.tr((String[])new String[]{"tofix:Not a Error item"}), (int)78, (int)5007);
        MainApplication.registerActionShortcut((Action)new NotError_key_Action(), (Shortcut)this.noterrorButtonShortcut);
        this.jPanelProjects.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelQuery.setBorder(BorderFactory.createEtchedBorder());
        this.TabbedPanel.addTab(ExpressionFactory.Functions.tr((String[])new String[]{"Projects"}), this.jContentPanelProjects);
        this.createLayout(this.TabbedPanel, false, Arrays.asList(this.skipButton, this.noterrorButton, this.fixedButton));
        this.oauth = new JDOAuth((Component)MainApplication.getMainFrame());
        this.host = new JDHost((Component)MainApplication.getMainFrame());
        this.loadOAuthInfo();
    }

    public void fillCombo() {
        this.listStringsForCombo.clear();
        this.listStringsForCombo.add(ExpressionFactory.Functions.tr((String[])new String[]{"Select a project ..."}));
        if (Status.isInternetReachable()) {
            this.projectsList = this.listProjectController.getListProjects();
            for (int i = 0; i < this.projectsList.getProjects().size(); ++i) {
                this.listStringsForCombo.add(this.projectsList.getProjects().get(i).getName());
            }
            this.jcomboBox.setModel(new DefaultComboBoxModel());
            this.jcomboBox.setModel(new DefaultComboBoxModel<String>(this.listStringsForCombo.toArray(new String[0])));
        } else {
            this.skipButton.setEnabled(false);
            this.fixedButton.setEnabled(false);
            this.noterrorButton.setEnabled(false);
        }
    }

    public void setToken() {
        if (Status.serverStatus()) {
            this.oauth.setVisible(true);
            if (this.oauth.getTofixToken() != null && !this.oauth.getTofixToken().equals("")) {
                if (Config.preferences(0, new String[]{"tofix-server.token"}, Config.getPluginPreferencesFile().getAbsolutePath()) != null) {
                    Config.preferences(1, new String[]{"tofix-server.token", this.oauth.getTofixToken()}, Config.getPluginPreferencesFile().getAbsolutePath());
                } else {
                    Config.preferences(2, new String[]{"tofix-server.token", this.oauth.getTofixToken()}, Config.getPluginPreferencesFile().getAbsolutePath());
                }
                this.fillCombo();
            } else {
                this.fillCombo();
            }
        } else {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), ExpressionFactory.Functions.tr((String[])new String[]{"API did not response! "}) + Config.getHOST());
        }
    }

    private void setHost() {
        this.host.setVisible(true);
        if (this.host.getHost() != null && this.host.getHost().equals("")) {
            this.fillCombo();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.start();
        JComboBox cb = (JComboBox)e.getSource();
        if (cb.getSelectedIndex() != 0) {
            this.mainAccessToProject.setProject_id(this.projectsList.getProjects().get(cb.getSelectedIndex() - 1).getId());
            this.mainAccessToProject.setProject_name(this.projectsList.getProjects().get(cb.getSelectedIndex() - 1).getName());
            this.project = this.projectsList.getProjects().get(cb.getSelectedIndex() - 1);
            this.deleteLayer();
            this.getNewItem();
            this.skipButton.setEnabled(true);
            this.fixedButton.setEnabled(true);
            this.noterrorButton.setEnabled(true);
        } else {
            this.skipButton.setEnabled(false);
            this.fixedButton.setEnabled(false);
            this.noterrorButton.setEnabled(false);
        }
    }

    private void loadOAuthInfo() {
        if (!Config.getUserName().equals("")) {
            this.TabbedPanel.addTab(ExpressionFactory.Functions.tr((String[])new String[]{"Activation"}), this.jContenActivation);
            this.TabbedPanel.addTab(ExpressionFactory.Functions.tr((String[])new String[]{"Querying"}), this.jPanelQuery);
            this.oauth.setUserInfo(Config.getUserName(), Config.getPassword(), Config.getTOKEN());
            if (this.oauth.getTofixToken() != null && !this.oauth.getTofixToken().equals("")) {
                if (Status.serverStatus()) {
                    this.fillCombo();
                }
                if (Config.isDefaultToken(this.oauth.getTofixToken())) {
                    this.jCheckBoxToken.setSelected(true);
                } else {
                    this.jCheckBoxToken.setSelected(false);
                }
            }
            this.host.setHost(Config.getHOST());
            if (this.host.getHost() != null && !this.host.getHost().equals("")) {
                if (Config.isDefaultAPI(this.host.getHost())) {
                    this.jCheckBoxSetNewAPI.setSelected(true);
                } else {
                    this.jCheckBoxSetNewAPI.setSelected(false);
                }
            }
        }
    }

    private void eventFixed(ActionEvent e) {
        if (!MainApplication.getLayerManager().getActiveLayer().isSavable() || !MainApplication.getLayerManager().getEditDataSet().isModified()) {
            new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"No changes to upload."})).show();
            this.fixed();
        } else {
            Bounds bounds = new Bounds((Rectangle2D)MainApplication.getLayerManager().getEditDataSet().getDataSourceArea().getBounds());
            if (bounds.getArea() < 30.0) {
                this.validator = false;
                UploadDialog.getUploadDialog().addComponentListener((ComponentListener)new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        TofixDialog.this.validator = true;
                    }
                });
                DataSet data = MainApplication.getLayerManager().getEditLayer().data;
                this.project.getChangesetComment();
                if (!this.project.getChangesetComment().equals("none")) {
                    data.getChangeSetTags().put("comment", this.project.getChangesetComment());
                }
                data.getChangeSetTags().put("source", MainApplication.getMap().mapView.getLayerInformationForSourceTag());
                new UploadAction().actionPerformed(e);
                if (this.validator && !UploadDialog.getUploadDialog().isCanceled() && UploadDialog.getUploadDialog().getChangeset().isNew()) {
                    this.fixed();
                    this.deleteLayer();
                }
            } else {
                new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"The bounding box of the edited layer is too big."})).show();
            }
        }
    }

    private void getNewItem() {
        this.itemController.setAccessToProject(this.mainAccessToProject);
        this.item = this.itemController.getItem();
        switch (this.item.getStatusServer()) {
            case 200: {
                this.mainAccessToProject.setAccess(true);
                this.mainAccessToProject = this.tofixProject.work(this.item, this.mainAccessToProject, this.zise, this.isCheckedDownloadOSMData, this.isCheckedEditableData);
                this.edit();
                break;
            }
            case 410: {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), ExpressionFactory.Functions.tr((String[])new String[]{"There are no more items on this Project or Area!"}), ExpressionFactory.Functions.tr((String[])new String[]{"Warning"}), 2);
                this.mainAccessToProject.setAccess(false);
                break;
            }
            default: {
                this.mainAccessToProject.setAccess(false);
                new Notification(ExpressionFactory.Functions.tr((String[])new String[]{"Something went wrong, try again"})).show();
            }
        }
    }

    public void edit() {
        this.itemTrackController.lockItem(this.item, "locked");
    }

    public void skip() {
        this.itemTrackController.lockItem(this.item, "unlocked");
        this.getNewItem();
    }

    public void fixed() {
        this.itemTrackController.updateStatusItem(this.item, "fixed");
        this.getNewItem();
    }

    public void notError() {
        this.itemTrackController.updateStatusItem(this.item, "noterror");
        this.getNewItem();
    }

    public final void start() {
        this.mainAccessToProject = new AccessToProject("mixedlayer", false);
    }

    public void downloadCancelled() {
        this.skip();
        this.deleteLayer();
    }

    public void deleteLayer() {
        OsmDataLayer editLayer;
        if (this.needDeleteLayer && (editLayer = MainApplication.getLayerManager().getEditLayer()) != null) {
            editLayer.data.clear();
            MainApplication.getLayerManager().removeLayer((Layer)editLayer);
        }
    }

    public class NotError_key_Action
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TofixDialog.this.notError();
            TofixDialog.this.deleteLayer();
        }
    }

    public class fixedKeyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TofixDialog.this.eventFixed(e);
        }
    }

    public class skipKeyAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            TofixDialog.this.skip();
            TofixDialog.this.deleteLayer();
        }
    }
}

