/*
 * Decompiled with CFR 0.152.
 */
package us.monoid.web;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.xpath.XPathException;
import us.monoid.json.JSONObject;
import us.monoid.web.AbstractContent;
import us.monoid.web.AbstractResource;
import us.monoid.web.BinaryResource;
import us.monoid.web.Content;
import us.monoid.web.Deletion;
import us.monoid.web.FormContent;
import us.monoid.web.FormData;
import us.monoid.web.JSONPathQuery;
import us.monoid.web.JSONResource;
import us.monoid.web.Replacement;
import us.monoid.web.TextResource;
import us.monoid.web.XMLResource;
import us.monoid.web.XPathQuery;
import us.monoid.web.auth.RestyAuthenticator;
import us.monoid.web.mime.MultipartContent;

public class Resty {
    protected static String MOZILLA = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10.6; en-US; rv:1.9.2.13) Gecko/20101203 Firefox/3.6.13";
    protected static String DEFAULT_USER_AGENT = "Resty/0.1 (Java)";
    static RestyAuthenticator rath = new RestyAuthenticator();
    protected String userAgent = DEFAULT_USER_AGENT;
    private java.net.Proxy proxy = java.net.Proxy.NO_PROXY;
    private Map<String, String> additionalHeaders;
    private Option[] options;

    public Resty(Option ... someOptions) {
        this.setOptions(someOptions);
    }

    public Resty setOptions(Option ... someOptions) {
        for (Option o : this.options = someOptions == null ? new Option[]{} : someOptions) {
            o.init(this);
        }
        return this;
    }

    public void authenticate(URI aSite, String aLogin, char[] aPwd) {
        rath.addSite(aSite, aLogin, aPwd);
    }

    public void authenticate(String string, String aLogin, char[] charArray) {
        this.authenticate(URI.create(string), aLogin, charArray);
    }

    public void authenticateForRealm(String realm, String aLogin, char[] charArray) {
        rath.addRealm(realm, aLogin, charArray);
    }

    public Resty identifyAsMozilla() {
        this.userAgent = MOZILLA;
        return this;
    }

    public Resty identifyAsResty() {
        this.userAgent = DEFAULT_USER_AGENT;
        return this;
    }

    public JSONResource json(String string) throws IOException {
        return this.json(URI.create(string));
    }

    public JSONResource json(URI anUri) throws IOException {
        return this.doGET(anUri, this.createJSONResource());
    }

    protected JSONResource createJSONResource() {
        return new JSONResource(this.options);
    }

    public JSONResource json(URI anUri, AbstractContent requestContent) throws IOException {
        return this.doPOSTOrPUT(anUri, requestContent, this.createJSONResource());
    }

    public JSONResource json(String anUri, AbstractContent content) throws IOException {
        return this.json(URI.create(anUri), content);
    }

    public TextResource text(URI anUri) throws IOException {
        return this.doGET(anUri, this.createTextResource());
    }

    protected TextResource createTextResource() {
        return new TextResource(this.options);
    }

    public TextResource text(URI anUri, AbstractContent content) throws IOException {
        return this.doPOSTOrPUT(anUri, content, this.createTextResource());
    }

    public TextResource text(String anUri) throws IOException {
        return this.text(URI.create(anUri));
    }

    public TextResource text(String anUri, AbstractContent content) throws IOException {
        return this.text(URI.create(anUri), content);
    }

    public XMLResource xml(String string) throws IOException {
        return this.xml(URI.create(string));
    }

    public XMLResource xml(URI anUri) throws IOException {
        return this.doGET(anUri, this.createXMLResource());
    }

    protected XMLResource createXMLResource() {
        return new XMLResource(this.options);
    }

    public XMLResource xml(URI anUri, AbstractContent requestContent) throws IOException {
        return this.doPOSTOrPUT(anUri, requestContent, this.createXMLResource());
    }

    public XMLResource xml(String anUri, AbstractContent content) throws IOException {
        return this.xml(URI.create(anUri), content);
    }

    public BinaryResource bytes(String anUri) throws IOException {
        return this.bytes(URI.create(anUri));
    }

    public BinaryResource bytes(URI anUri) throws IOException {
        return this.doGET(anUri, this.createBinaryResource());
    }

    protected BinaryResource createBinaryResource() {
        return new BinaryResource(this.options);
    }

    public BinaryResource bytes(String anUri, AbstractContent someContent) throws IOException {
        return this.bytes(URI.create(anUri), someContent);
    }

    public BinaryResource bytes(URI anUri, AbstractContent someContent) throws IOException {
        return this.doPOSTOrPUT(anUri, someContent, this.createBinaryResource());
    }

    protected <T extends AbstractResource> T doGET(URI anUri, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> T doPOSTOrPUT(URI anUri, AbstractContent requestContent, T resource) throws IOException {
        URLConnection con = this.openConnection(anUri, resource);
        requestContent.addContent(con);
        return this.fillResourceFromURL(con, resource);
    }

    protected <T extends AbstractResource> URLConnection openConnection(URI anUri, T resource) throws IOException, MalformedURLException {
        URLConnection con = anUri.toURL().openConnection(this.proxy);
        this.addStandardHeaders(con, resource);
        this.addAdditionalHeaders(con);
        for (Option o : this.options) {
            o.apply(con);
        }
        return con;
    }

    protected void addAdditionalHeaders(URLConnection con) {
        for (Map.Entry<String, String> header : this.getAdditionalHeaders().entrySet()) {
            con.addRequestProperty(header.getKey(), header.getValue());
        }
    }

    protected <T extends AbstractResource> void addStandardHeaders(URLConnection con, T resource) {
        con.setRequestProperty("User-Agent", this.userAgent);
        con.setRequestProperty("Accept", resource.getAcceptedTypes());
    }

    protected <T extends AbstractResource> T fillResourceFromURL(URLConnection con, T resource) throws IOException {
        resource.fill(con);
        resource.getAdditionalHeaders().putAll(this.getAdditionalHeaders());
        return resource;
    }

    public static JSONPathQuery path(String string) {
        return new JSONPathQuery(string);
    }

    public static XPathQuery xpath(String anXPathExpression) throws XPathException {
        return new XPathQuery(anXPathExpression);
    }

    public static Content content(JSONObject someJson) {
        Content c = null;
        try {
            c = new Content("application/json; charset=UTF-8", someJson.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return c;
    }

    public static Content content(String somePlainText) {
        Content c = null;
        try {
            c = new Content("text/plain; charset=UTF-8", somePlainText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return c;
    }

    public static Content content(byte[] bytes) {
        return new Content("application/octet-stream", bytes);
    }

    public static FormContent form(String query) {
        FormContent fc = new FormContent(query);
        return fc;
    }

    public static MultipartContent form(FormData ... formData) {
        MultipartContent mc = new MultipartContent("form-data", formData);
        return mc;
    }

    public static FormData data(String name, String plainTextValue) {
        return Resty.data(name, Resty.content(plainTextValue));
    }

    public static FormData data(String name, AbstractContent content) {
        return new FormData(name, content);
    }

    public static String enc(String unencodedString) {
        try {
            return URLEncoder.encode(unencodedString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static AbstractContent put(Content someContent) {
        return new Replacement(someContent);
    }

    public static AbstractContent delete() {
        return new Deletion();
    }

    public void alwaysSend(String aHeader, String aValue) {
        this.getAdditionalHeaders().put(aHeader, aValue);
    }

    public void withHeader(String aHeader, String aValue) {
        this.getAdditionalHeaders().put(aHeader, aValue);
    }

    public void dontSend(String aHeader) {
        this.getAdditionalHeaders().remove(aHeader);
    }

    protected Map<String, String> getAdditionalHeaders() {
        if (this.additionalHeaders == null) {
            this.additionalHeaders = new HashMap<String, String>();
        }
        return this.additionalHeaders;
    }

    public static void ignoreAllCerts() {
        X509TrustManager trm = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, new TrustManager[]{trm}, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    public void setProxy(String proxyhost, int proxyport) {
        this.proxy = new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyhost, proxyport));
    }

    static {
        try {
            if (CookieHandler.getDefault() == null) {
                CookieHandler.setDefault(new CookieManager());
            }
        }
        catch (NoClassDefFoundError oops) {
            System.err.println("No CookieHandler. Running on GAE? Fine. No cookie support for you!");
        }
        Authenticator.setDefault(rath);
    }

    public static class Proxy
    extends Option {
        private String host;
        private int port;

        public Proxy(String aHost, int aPort) {
            this.host = aHost;
            this.port = aPort;
        }

        @Override
        public void init(Resty resty) {
            resty.setProxy(this.host, this.port);
        }
    }

    public static class Timeout
    extends Option {
        private int timeout;

        public Timeout(int t) {
            this.timeout = t;
        }

        @Override
        public void apply(URLConnection urlConnection) {
            urlConnection.setConnectTimeout(this.timeout);
        }
    }

    public static abstract class Option {
        public void apply(URLConnection aConnection) {
        }

        public void init(Resty resty) {
        }

        public static Timeout timeout(int t) {
            return new Timeout(t);
        }

        public static Proxy proxy(String aHostName, int aPortNumber) {
            return new Proxy(aHostName, aPortNumber);
        }
    }
}

