/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.monocle.KeyInput;
import com.sun.glass.ui.monocle.KeyState;
import com.sun.glass.ui.monocle.MouseInput;
import com.sun.glass.ui.monocle.MouseState;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;

class MonocleRobot
extends GlassRobot {
    MonocleRobot() {
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void keyPress(KeyCode code) {
        Application.checkEventThread();
        KeyState state = new KeyState();
        KeyInput.getInstance().getState(state);
        state.pressKey(code.getCode());
        KeyInput.getInstance().setState(state);
    }

    @Override
    public void keyRelease(KeyCode code) {
        Application.checkEventThread();
        KeyState state = new KeyState();
        KeyInput.getInstance().getState(state);
        state.releaseKey(code.getCode());
        KeyInput.getInstance().setState(state);
    }

    @Override
    public void mouseMove(double x, double y) {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        state.setX((int)x);
        state.setY((int)y);
        MouseInput.getInstance().setState(state, false);
    }

    private static MouseState convertToMouseState(boolean press, MouseState state, MouseButton ... buttons) {
        block5: for (MouseButton button : buttons) {
            switch (button) {
                case PRIMARY: {
                    if (press) {
                        state.pressButton(212);
                        continue block5;
                    }
                    state.releaseButton(212);
                    continue block5;
                }
                case SECONDARY: {
                    if (press) {
                        state.pressButton(213);
                        continue block5;
                    }
                    state.releaseButton(213);
                    continue block5;
                }
                case MIDDLE: {
                    if (press) {
                        state.pressButton(214);
                        continue block5;
                    }
                    state.releaseButton(214);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + button + " not supported by Monocle Robot");
                }
            }
        }
        return state;
    }

    @Override
    public void mousePress(MouseButton ... buttons) {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        MouseInput.getInstance().setState(MonocleRobot.convertToMouseState(true, state, buttons), false);
    }

    @Override
    public void mouseRelease(MouseButton ... buttons) {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        MouseInput.getInstance().setState(MonocleRobot.convertToMouseState(false, state, buttons), false);
    }

    @Override
    public void mouseWheel(int wheelAmt) {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput mouse = MouseInput.getInstance();
        mouse.getState(state);
        int direction = wheelAmt < 0 ? -1 : 1;
        for (int i = 0; i < Math.abs(wheelAmt); ++i) {
            state.setWheel(direction);
            mouse.setState(state, false);
            state.setWheel(0);
            mouse.setState(state, false);
        }
    }

    @Override
    public double getMouseX() {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getX();
    }

    @Override
    public double getMouseY() {
        Application.checkEventThread();
        MouseState state = new MouseState();
        MouseInput.getInstance().getState(state);
        return state.getY();
    }

    @Override
    public Color getPixelColor(double x, double y) {
        Application.checkEventThread();
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int byteDepth = screen.getDepth() >>> 3;
        int bwidth = screen.getWidth();
        int bheight = screen.getHeight();
        if (x < 0.0 || x > (double)bwidth || y < 0.0 || y > (double)bheight) {
            return GlassRobot.convertFromIntArgb(0);
        }
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            ByteBuffer buffer = screen.getScreenCapture();
            if (byteDepth == 2) {
                ShortBuffer shortbuf = buffer.asShortBuffer();
                short v = shortbuf.get((int)(y * (double)bwidth) + (int)x);
                int red = (v & 0xF800) >> 11 << 3;
                int green = (v & 0x7E0) >> 5 << 2;
                int blue = (v & 0x1F) << 3;
                int p = 0xFF000000 | red << 16 | green << 8 | blue;
                return GlassRobot.convertFromIntArgb(p);
            }
            if (byteDepth >= 4) {
                IntBuffer intbuf = buffer.asIntBuffer();
                return GlassRobot.convertFromIntArgb(intbuf.get((int)(y * (double)bwidth) + (int)x));
            }
            throw new RuntimeException("Unknown bit depth: " + byteDepth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getScreenCapture(int x, int y, int width, int height, int[] data, boolean scaleToFit) {
        Application.checkEventThread();
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        int scrWidth = screen.getWidth();
        int scrHeight = screen.getHeight();
        Object object = NativeScreen.framebufferSwapLock;
        synchronized (object) {
            IntBuffer buffer = screen.getScreenCapture().asIntBuffer();
            if (x == 0 && y == 0 && width == scrWidth && height == scrHeight) {
                System.arraycopy(buffer.array(), 0, data, 0, buffer.array().length);
                return;
            }
            int rowStop = Math.min(y + height, scrHeight);
            int colStop = Math.min(x + width, scrWidth);
            for (int row = y; row < rowStop; ++row) {
                for (int col = x; col < colStop; ++col) {
                    data[row * scrWidth + col] = buffer.get(row * scrWidth + col);
                }
            }
        }
    }
}

