/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.openjfx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.audio.AudioPlayer;
import org.openstreetmap.josm.plugins.DynamicURLClassLoader;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.openjfx.io.audio.JavaFxMediaPlayer;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.PlatformManager;

public class OpenJfxPlugin
extends Plugin {
    public OpenJfxPlugin(PluginInformation info) {
        super(info);
        AudioPlayer.setSoundPlayerClass(JavaFxMediaPlayer.class);
        String ext = null;
        if (PlatformManager.isPlatformWindows()) {
            ext = ".dll";
        } else if (PlatformManager.isPlatformUnixoid()) {
            ext = ".so";
        } else if (PlatformManager.isPlatformOsx()) {
            ext = ".dylib";
        }
        OpenJfxPlugin.extractNativeLibs(ext);
        this.loadNativeLibs(ext);
    }

    private static void extractNativeLibs(String ext) {
        CodeSource src = OpenJfxPlugin.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            try (ZipFile zf = new ZipFile(Paths.get(src.getLocation().toURI()).toFile(), StandardCharsets.UTF_8);){
                Path dir = OpenJfxPlugin.getNativeDir();
                Enumeration<? extends ZipEntry> es = zf.entries();
                while (es.hasMoreElements()) {
                    Path targetPath;
                    File targetFile;
                    ZipEntry ze = es.nextElement();
                    String name = ze.getName();
                    if (!name.endsWith(ext) && !name.endsWith(".jar") || (targetFile = (targetPath = dir.resolve(name)).toFile()).exists() && targetFile.lastModified() >= ze.getTime()) continue;
                    InputStream is = zf.getInputStream(ze);
                    Throwable throwable = null;
                    try {
                        Logging.debug((String)("Extracting " + targetPath));
                        Files.copy(is, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        OpenJfxPlugin.$closeResource(throwable, is);
                    }
                }
            }
            catch (IOException | URISyntaxException e) {
                Logging.error((Throwable)e);
            }
        } else {
            Logging.error((String)"Unable to locate openjfx jar file");
        }
    }

    private static Path getNativeDir() throws IOException {
        return Files.createDirectories(new File(Preferences.main().getPluginsDirectory(), "openjfx").toPath(), new FileAttribute[0]);
    }

    private void loadNativeLibs(String ext) {
        try {
            Files.walkFileTree(OpenJfxPlugin.getNativeDir(), new LibVisitor(ext));
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
        }
    }

    private static class LibVisitor
    extends SimpleFileVisitor<Path> {
        private final ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        private final String ext;

        public LibVisitor(String ext) {
            this.ext = Objects.requireNonNull(ext);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.ccl instanceof DynamicURLClassLoader) {
                if (file.endsWith(this.ext)) {
                    Logging.debug((String)("Loading " + file));
                    System.load(file.toAbsolutePath().toString());
                } else if (file.endsWith(".jar")) {
                    Logging.debug((String)("Loading " + file));
                    ((DynamicURLClassLoader)this.ccl).addURL(file.toUri().toURL());
                }
            } else {
                Logging.error((String)("Unexpected context class loader: " + this.ccl));
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

