/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.photoadjust;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.dialogs.LatLonDialog;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.ImageViewerDialog;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PhotoPropertyEditor {
    public static void init() {
        MainMenu.add((JMenu)MainApplication.getMenu().editMenu, (JosmAction)new PropertyEditorAction());
    }

    private static void updateLayer(GeoImageLayer layer, ImageEntry photo) {
        layer.updateBufferAndRepaint();
        ImageViewerDialog.showImage((GeoImageLayer)layer, (ImageEntry)photo);
    }

    private static class PropertyEditorDialog
    extends ExtendedDialog {
        private final JosmTextField coords = new JosmTextField(24);
        private final JosmTextField altitude = new JosmTextField();
        private final JosmTextField speed = new JosmTextField();
        private final JosmTextField direction = new JosmTextField();
        private final ImageEntry image;
        private final GeoImageLayer layer;
        private final GpxImageEntry imgOrig;
        private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);

        public PropertyEditorDialog(String title, final ImageEntry image, final GeoImageLayer layer) {
            super((Component)MainApplication.getMainFrame(), title, new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
            this.image = image;
            this.layer = layer;
            this.imgOrig = image.clone();
            this.setButtonIcons(new String[]{"ok", "cancel"});
            JPanel content = new JPanel(new GridBagLayout());
            if (image.hasThumbnail() || image.getFile() != null) {
                JLabel header = new JLabel(image.getFile() != null ? image.getFile().getName() : "");
                if (!image.hasThumbnail()) {
                    image.loadThumbnail();
                }
                if (image.hasThumbnail()) {
                    header.setIcon(new ImageIcon(image.getThumbnail()));
                }
                content.add((Component)header, GBC.eol().fill().weight(1.0, 1.0));
            }
            content.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
            content.add((Component)new JLabel(I18n.tr((String)"(Empty values delete the according fields.)", (Object[])new Object[0])), GBC.eol());
            this.coords.setHint(I18n.tr((String)"coordinates", (Object[])new Object[0]));
            LatLonInputVerifier coordsVerif = new LatLonInputVerifier();
            this.coords.getDocument().addDocumentListener(coordsVerif);
            this.coords.setToolTipText(I18n.tr((String)"Latitude and longitude", (Object[])new Object[0]));
            content.add((Component)new JLabel(I18n.tr((String)"Coordinates:", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
            content.add((Component)this.coords, GBC.std().fill(2));
            AbstractAction editCoordAction = new AbstractAction(I18n.tr((String)"Edit", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LatLon coordinates;
                    LatLonDialog llDialog = new LatLonDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Edit Image Coordinates", (Object[])new Object[0]), null);
                    llDialog.setCoordinates(this.getLatLon());
                    llDialog.showDialog();
                    if (llDialog.getValue() == 1 && (coordinates = llDialog.getCoordinates()) != null) {
                        coords.setText(PropertyEditorDialog.posToText(coordinates));
                    }
                }
            };
            JButton editCoordBtn = new JButton(editCoordAction);
            editCoordBtn.setToolTipText(I18n.tr((String)"Edit coordinates in separate editor", (Object[])new Object[0]));
            content.add((Component)editCoordBtn, GBC.eol());
            this.altitude.setHint(I18n.tr((String)"altitude", (Object[])new Object[0]));
            DoubleInputVerifier altVerif = new DoubleInputVerifier(this.altitude){

                @Override
                public void updateValue(Double value) {
                    image.getTmp().setElevation(value);
                    PhotoPropertyEditor.updateLayer(layer, image);
                }
            };
            this.altitude.getDocument().addDocumentListener(altVerif);
            content.add((Component)new JLabel(I18n.tr((String)"Altitude:", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
            content.add((Component)this.altitude, GBC.std().fill(2));
            content.add((Component)new JLabel(I18n.tr((String)"m", (Object[])new Object[0])), GBC.eol());
            this.speed.setHint(I18n.tr((String)"speed", (Object[])new Object[0]));
            DoubleInputVerifier speedVerif = new DoubleInputVerifier(this.speed){

                @Override
                public void updateValue(Double value) {
                    image.getTmp().setSpeed(value);
                    PhotoPropertyEditor.updateLayer(layer, image);
                }
            };
            speedVerif.setMinMax(0.0, null);
            this.speed.getDocument().addDocumentListener(speedVerif);
            this.speed.setToolTipText(I18n.tr((String)"positive number or empty", (Object[])new Object[0]));
            content.add((Component)new JLabel(I18n.tr((String)"Speed:", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
            content.add((Component)this.speed, GBC.std().fill(2));
            content.add((Component)new JLabel(I18n.tr((String)"km/h", (Object[])new Object[0])), GBC.eol());
            this.direction.setHint(I18n.tr((String)"direction", (Object[])new Object[0]));
            DoubleInputVerifier dirVerif = new DoubleInputVerifier(this.direction){

                @Override
                public void updateValue(Double value) {
                    image.getTmp().setExifImgDir(value);
                    PhotoPropertyEditor.updateLayer(layer, image);
                }
            };
            dirVerif.setMinMax(-360.0, 360.0);
            this.direction.getDocument().addDocumentListener(dirVerif);
            this.direction.setToolTipText(I18n.tr((String)"range -360.0 .. 360.0, or empty", (Object[])new Object[0]));
            content.add((Component)new JLabel(I18n.tr((String)"Direction:", (Object[])new Object[0])), GBC.std().insets(0, 0, 5, 0));
            content.add((Component)this.direction, GBC.std().fill(2));
            content.add((Component)new JLabel(I18n.tr((String)"\u00b0", (Object[])new Object[0])), GBC.eol());
            this.setInitialValues();
            JPanel buttonsPanel = new JPanel(new GridBagLayout());
            AbstractAction undoAction = new AbstractAction(I18n.tr((String)"Undo", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.setInitialValues();
                }
            };
            JButton undoButton = new JButton(undoAction);
            undoButton.setToolTipText(I18n.tr((String)"Undo changes made in this dialog", (Object[])new Object[0]));
            undoButton.setIcon(ImageProvider.get((String)"undo"));
            buttonsPanel.add((Component)undoButton, GBC.std().insets(2, 2, 2, 2));
            AbstractAction reloadAction = new AbstractAction(I18n.tr((String)"Reload", (Object[])new Object[0])){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ImageEntry imgTmp = new ImageEntry(image.getFile());
                    imgTmp.extractExif();
                    this.setInitialValues(imgTmp);
                }
            };
            JButton reloadButton = new JButton(reloadAction);
            reloadButton.setToolTipText(I18n.tr((String)"Reload GPS data from image file", (Object[])new Object[0]));
            reloadButton.setIcon(ImageProvider.get((String)"dialogs/refresh"));
            buttonsPanel.add((Component)reloadButton, GBC.std().insets(2, 2, 2, 2));
            content.add((Component)buttonsPanel, GBC.eol().insets(0, 5, 0, 5));
            this.setContent(content, false);
            this.showDialog();
        }

        private void setInitialValues() {
            this.image.discardTmp();
            this.setInitialValues(this.image);
        }

        private static String posToText(LatLon pos) {
            return pos == null ? "" : CoordinateFormatManager.getDefaultFormat().latToString((ILatLon)pos) + ' ' + CoordinateFormatManager.getDefaultFormat().lonToString((ILatLon)pos);
        }

        private void setInitialValues(ImageEntry image) {
            if (image.getPos() != null) {
                this.coords.setText(PropertyEditorDialog.posToText((LatLon)image.getPos()));
            } else {
                this.coords.setText(null);
            }
            if (image.getElevation() != null) {
                this.altitude.setText(image.getElevation().toString());
            } else {
                this.altitude.setText(null);
            }
            if (image.getSpeed() != null) {
                this.speed.setText(image.getSpeed().toString());
            } else {
                this.speed.setText(null);
            }
            if (image.getExifImgDir() != null) {
                this.direction.setText(image.getExifImgDir().toString());
            } else {
                this.direction.setText(null);
            }
        }

        private boolean isDoubleFieldDifferent(JosmTextField txtFld, Double value) {
            Double fieldValue = PropertyEditorDialog.getDoubleValue(txtFld);
            return fieldValue == null ? value != null : value == null || fieldValue.doubleValue() != value.doubleValue();
        }

        private static Double getDoubleValue(JosmTextField txtFld) {
            String text = txtFld.getText();
            if (text == null || text.isEmpty()) {
                return null;
            }
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }

        public void updateImageTmp() {
            GpxImageEntry imgTmp = this.image.getTmp();
            String text = this.coords.getText();
            if (text == null || text.isEmpty()) {
                imgTmp.setPos(null);
                if (this.imgOrig.getPos() != null) {
                    imgTmp.flagNewGpsData();
                }
            } else {
                imgTmp.setPos(this.getLatLon());
                if (this.imgOrig.getPos() == null || !PropertyEditorDialog.posToText((LatLon)this.imgOrig.getPos()).equals(PropertyEditorDialog.posToText((LatLon)imgTmp.getPos()))) {
                    imgTmp.flagNewGpsData();
                }
            }
            if (this.isDoubleFieldDifferent(this.altitude, imgTmp.getElevation())) {
                imgTmp.flagNewGpsData();
                imgTmp.setElevation(PropertyEditorDialog.getDoubleValue(this.altitude));
            }
            if (this.isDoubleFieldDifferent(this.speed, imgTmp.getSpeed())) {
                imgTmp.flagNewGpsData();
                imgTmp.setSpeed(PropertyEditorDialog.getDoubleValue(this.speed));
            }
            if (this.isDoubleFieldDifferent(this.direction, imgTmp.getExifImgDir())) {
                imgTmp.flagNewGpsData();
                Double imgDir = PropertyEditorDialog.getDoubleValue(this.direction);
                if (imgDir != null) {
                    if (imgDir < 0.0) {
                        imgDir = imgDir % 360.0;
                        imgDir = imgDir + 360.0;
                    }
                    if (imgDir >= 360.0) {
                        imgDir = imgDir % 360.0;
                    }
                }
                imgTmp.setExifImgDir(imgDir);
            }
        }

        private LatLon getLatLon() {
            LatLon latLon;
            try {
                latLon = LatLonParser.parse((String)this.coords.getText());
                if (!latLon.isValid()) {
                    latLon = null;
                }
            }
            catch (IllegalArgumentException exn) {
                latLon = null;
            }
            return latLon;
        }

        protected LatLon parseLatLonUserInput() {
            LatLon latLon;
            String coordsText = this.coords.getText();
            try {
                latLon = LatLonParser.parse((String)coordsText);
            }
            catch (IllegalArgumentException exn) {
                latLon = null;
            }
            if (latLon == null && coordsText != null && !coordsText.isEmpty()) {
                this.setErrorFeedback(this.coords);
                this.setOkEnabled(false);
                latLon = null;
            } else {
                this.clearErrorFeedback(this.coords);
                this.setOkEnabled(true);
            }
            return latLon;
        }

        protected Double parseDoubleUserInput(JosmTextField txtFld, Double min, Double max) {
            boolean isError = false;
            String text = txtFld.getText();
            Double value = null;
            if (text != null && !text.isEmpty()) {
                try {
                    value = Double.valueOf(text);
                    if (min != null && value < min) {
                        isError = true;
                    }
                    if (max != null && value > max) {
                        isError = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    isError = true;
                }
            }
            if (isError) {
                this.setErrorFeedback(txtFld);
                this.setOkEnabled(false);
                value = null;
            } else {
                this.clearErrorFeedback(txtFld);
                this.setOkEnabled(true);
            }
            return value;
        }

        protected void setErrorFeedback(JosmTextField txtFld) {
            txtFld.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
            txtFld.setBackground(BG_COLOR_ERROR);
        }

        protected void clearErrorFeedback(JosmTextField txtFld) {
            txtFld.setBorder(UIManager.getBorder("TextField.border"));
            txtFld.setBackground(UIManager.getColor("TextField.background"));
        }

        private void setOkEnabled(boolean enabled) {
            if (this.buttons != null && !this.buttons.isEmpty()) {
                ((JButton)this.buttons.get(0)).setEnabled(enabled);
            }
        }

        abstract class DoubleInputVerifier
        implements DocumentListener,
        UpdateDoubleValue {
            private final JosmTextField textField;
            private Double minimum;
            private Double maximum;

            public DoubleInputVerifier(JosmTextField txtFld) {
                this.textField = txtFld;
            }

            public void setMinMax(Double min, Double max) {
                this.minimum = min;
                this.maximum = max;
            }

            private void doUpdate() {
                this.updateValue(PropertyEditorDialog.this.parseDoubleUserInput(this.textField, this.minimum, this.maximum));
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.doUpdate();
            }
        }

        public static interface UpdateDoubleValue {
            public void updateValue(Double var1);
        }

        class LatLonInputVerifier
        implements DocumentListener,
        UpdateLatLon {
            LatLonInputVerifier() {
            }

            private void doUpdate() {
                this.updateLatLon(PropertyEditorDialog.this.parseLatLonUserInput());
            }

            @Override
            public void updateLatLon(LatLon latLon) {
                PropertyEditorDialog.this.image.getTmp().setPos(latLon);
                PhotoPropertyEditor.updateLayer(PropertyEditorDialog.this.layer, PropertyEditorDialog.this.image);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.doUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.doUpdate();
            }
        }

        public static interface UpdateLatLon {
            public void updateLatLon(LatLon var1);
        }
    }

    private static class PropertyEditorAction
    extends JosmAction {
        public PropertyEditorAction() {
            super(I18n.tr((String)"Edit photo GPS data", (Object[])new Object[0]), (String)null, I18n.tr((String)"Edit GPS data of selected photo.", (Object[])new Object[0]), null, true, "photoadjust/propertyeditor", true);
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                PropertyEditorDialog dialog;
                ImageEntry photo = ImageViewerDialog.getCurrentImage();
                GeoImageLayer layer = ImageViewerDialog.getCurrentLayer();
                if (photo == null) {
                    throw new AssertionError((Object)"No image selected.");
                }
                StringBuilder title = new StringBuilder(I18n.tr((String)"Edit Photo GPS Data", (Object[])new Object[0]));
                if (photo.getFile() != null) {
                    title.append(" - ");
                    title.append(photo.getFile().getName());
                }
                if ((dialog = new PropertyEditorDialog(title.toString(), photo, layer)).getValue() == 1) {
                    dialog.updateImageTmp();
                    photo.applyTmp();
                } else {
                    photo.discardTmp();
                }
                PhotoPropertyEditor.updateLayer(layer, photo);
            }
            catch (AssertionError err) {
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Please select an image first.", (Object[])new Object[0]), I18n.tr((String)"No image selected", (Object[])new Object[0]), 1);
                return;
            }
        }

        private static boolean enabled() {
            try {
                ImageViewerDialog.getInstance().hasImage();
                return true;
            }
            catch (AssertionError err) {
                return false;
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(PropertyEditorAction.enabled());
        }
    }
}

