/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.housenumbertool;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.DataSelectionListener;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.SelectionEventManager;
import org.openstreetmap.josm.plugins.housenumbertool.TagDialog;
import org.openstreetmap.josm.tools.Shortcut;

public class LaunchAction
extends JosmAction
implements DataSelectionListener {
    private OsmPrimitive selection = null;
    private File pluginDir;

    public LaunchAction(File pluginDir) {
        super("HouseNumberTaggingTool", "home-icon32", "Launches the HouseNumberTaggingTool dialog", Shortcut.registerShortcut((String)"edit:housenumbertaggingtool", (String)"HouseNumberTaggingTool", (int)75, (int)5003), true);
        this.pluginDir = pluginDir;
        SelectionEventManager.getInstance().addSelectionListener((DataSelectionListener)this);
        this.setEnabled(false);
    }

    protected void launchEditor() {
        if (!this.isEnabled()) {
            return;
        }
        TagDialog dialog = new TagDialog(this.pluginDir, this.selection);
        dialog.showDialog();
    }

    public void actionPerformed(ActionEvent e) {
        this.launchEditor();
    }

    public void selectionChanged(DataSelectionListener.SelectionChangeEvent event) {
        Set newSelection = event.getSelection();
        if (newSelection != null && newSelection.size() == 1) {
            this.setEnabled(true);
            this.selection = (OsmPrimitive)newSelection.iterator().next();
        } else {
            this.setEnabled(false);
            this.selection = null;
        }
    }
}

